/**
 * License Agreement.
 *
 * Rich Faces - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.context;

import java.util.Iterator;

import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

import org.ajax4jsf.component.AjaxViewRoot;
import org.ajax4jsf.context.AjaxContext;

/**
 * @author shura
 *
 */
public class JsfOneOneInvoker implements ComponentInvoker {
	
	
	/**
	 * 
	 */
	public JsfOneOneInvoker() {
		// TODO Auto-generated constructor stub
	}
	
	
	/* (non-Javadoc)
	 * @see org.ajax4jsf.framework.ajax.AjaxInvoker#invokeOnRegionOrRoot(org.ajax4jsf.framework.ajax.AjaxViewRoot, javax.faces.context.FacesContext, org.ajax4jsf.framework.ajax.InvokerCallback, javax.faces.event.PhaseId)
	 */
	public void invokeOnRegionOrRoot(AjaxViewRoot viewRoot, FacesContext context, InvokerCallback callback) {
		AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
		String submittedRegionClientId = ajaxContext.getSubmittedRegionClientId();
		if(null == submittedRegionClientId || viewRoot.getId().equals(submittedRegionClientId)){
			// This is a not AJAX request, or active region is root.
			callback.invokeRoot(context);
		} else {
			if(!invokeOnComponent(viewRoot, context, callback, submittedRegionClientId)){
				// Region not found - perform default actions.
				// TODO - log errors.
				callback.invokeRoot(context);
			}
		}

	}
	
	public void invokeOnRegion(FacesContext context, InvokerCallback callback, String regionId) {
		UIViewRoot viewRoot = context.getViewRoot();
		invokeOnComponent(viewRoot,context,callback,regionId);
	}
	
	
	/* (non-Javadoc)
	 * @see org.ajax4jsf.framework.ajax.AjaxInvoker#invokeOnComponent(javax.faces.component.UIComponent, javax.faces.context.FacesContext, org.ajax4jsf.framework.ajax.InvokerCallback, java.lang.String)
	 */
	public boolean invokeOnComponent(UIComponent root, FacesContext context, InvokerCallback callback, String regionId) {
		if(regionId.equals(root.getClientId(context))){
			callback.invokeContextCallback(context, root);
			return true;
		}
		for (Iterator iter = root.getFacetsAndChildren(); iter.hasNext();) {
			UIComponent child = (UIComponent) iter.next();
			if(invokeOnComponent(child, context, callback, regionId)){
				return true;
			}
		}
		return false;
	}

}
