/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.GifRenderer;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.HtmlDimensions;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public class BaseControlBackgroundImage
extends Java2Dresource {
    private static final Dimension DIMENSION = new Dimension(1, 1);
    private String baseColor;
    private String gradientColor;
    private int width;

    public BaseControlBackgroundImage(String baseColor, String gradientColor, int width) {
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
        this.width = width;
        this.setRenderer(new GifRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    public Dimension getDimensions(FacesContext facesContext, Object data) {
        Data d = (Data)data;
        if (d != null) {
            return new Dimension(this.width, d.height);
        }
        return DIMENSION;
    }

    protected Dimension getDimensions(ResourceContext resourceContext) {
        return this.getDimensions(null, this.restoreData(resourceContext));
    }

    protected void paint(ResourceContext resourceContext, Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        Data dataToStore = (Data)this.restoreData(resourceContext);
        if (dataToStore != null && dataToStore.headerBackgroundColor != null && dataToStore.headerGradientColor != null) {
            Color baseColor = new Color(dataToStore.headerBackgroundColor);
            Dimension dim = this.getDimensions(resourceContext);
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, dim.height);
            Color alternateColor = new Color(dataToStore.headerGradientColor);
            GradientPaint gragient = new GradientPaint(0.0f, 0.0f, baseColor, 0.0f, dim.height, alternateColor);
            g2d.setPaint(gragient);
            g2d.fill(rect);
        }
    }

    protected final Integer getHeight(FacesContext context, String heightParamName) {
        SkinFactory skinFactory = SkinFactory.getInstance();
        Skin skin = skinFactory.getSkin(context);
        String height = (String)skin.getParameter(context, heightParamName);
        if (height == null || height.length() == 0) {
            skin = skinFactory.getDefaultSkin(context);
            height = (String)skin.getParameter(context, heightParamName);
        }
        if (height != null && height.length() != 0) {
            return HtmlDimensions.decode(height).intValue();
        }
        return 16;
    }

    protected Integer getHeight(FacesContext context) {
        return this.getHeight(context, "generalSizeFont");
    }

    protected Object deserializeData(byte[] objectArray) {
        Data data = new Data();
        if (objectArray != null) {
            Zipper2 zipper2 = new Zipper2(objectArray);
            data.headerBackgroundColor = new Integer(zipper2.nextIntColor());
            data.headerGradientColor = new Integer(zipper2.nextIntColor());
            data.height = new Integer(zipper2.nextInt());
        }
        return data;
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        Integer h = this.getHeight(context);
        if (this.baseColor == null) {
            return new Data(context, h).toByteArray();
        }
        return new Data(context, this.baseColor, this.gradientColor, h).toByteArray();
    }

    public boolean isCacheable() {
        return true;
    }

    protected static class Data
    implements Serializable {
        private static final long serialVersionUID = 1732700513743861250L;
        protected Integer headerBackgroundColor;
        protected Integer headerGradientColor;
        protected Integer height;

        public Data() {
        }

        protected Data(FacesContext context, Integer height) {
            this(context, "headerBackgroundColor", "headerGradientColor", height);
        }

        protected Data(FacesContext context, String baseColor, String gradientColor, Integer height) {
            this.headerBackgroundColor = this.getColorValueParameter(context, baseColor, false);
            this.headerGradientColor = this.getColorValueParameter(context, gradientColor, false);
            this.height = height;
            if (this.headerBackgroundColor != null || this.headerGradientColor != null) {
                if (this.headerBackgroundColor == null) {
                    this.headerBackgroundColor = this.getColorValueParameter(context, baseColor, true);
                }
                if (this.headerGradientColor == null) {
                    this.headerGradientColor = this.getColorValueParameter(context, gradientColor, true);
                }
            }
        }

        private Integer getColorValueParameter(FacesContext context, String name, boolean useDefault) {
            Skin skin = useDefault ? SkinFactory.getInstance().getDefaultSkin(context) : SkinFactory.getInstance().getSkin(context);
            String tmp = (String)skin.getParameter(context, name);
            if (tmp != null && tmp.length() != 0) {
                return new Integer(HtmlColor.decode(tmp).getRGB());
            }
            return null;
        }

        public byte[] toByteArray() {
            if (this.headerBackgroundColor != null && this.headerGradientColor != null) {
                byte[] ret = new byte[10];
                new Zipper2(ret).addColor(this.headerBackgroundColor).addColor(this.headerGradientColor).addInt(this.height);
                return ret;
            }
            return null;
        }
    }
}

