/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.component;

import java.io.IOException;
import java.util.NoSuchElementException;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.AjaxContainer;
import org.ajax4jsf.component.AjaxRegionBrige;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.AjaxContextImpl;
import org.ajax4jsf.context.InvokerCallback;
import org.ajax4jsf.context.ViewIdHolder;
import org.ajax4jsf.event.AjaxListener;
import org.ajax4jsf.event.EventsQueue;
import org.ajax4jsf.renderkit.AjaxContainerRenderer;

public class AjaxViewRoot
extends UIViewRoot
implements AjaxContainer {
    public static final String ROOT_ID = "_viewRoot";
    private AjaxRegionBrige _brige;
    private EventsQueue[] events;
    private EventsQueue ajaxEvents = new EventsQueue();
    private InvokerCallback _decodeInvoker = new InvokerCallback(){

        public void invokeContextCallback(FacesContext context, UIComponent component) {
            component.processDecodes(context);
        }

        public void invokeRoot(FacesContext context) {
            AjaxViewRoot.super.processDecodes(context);
        }
    };
    private InvokerCallback _updatesInvoker = new InvokerCallback(){

        public void invokeContextCallback(FacesContext context, UIComponent component) {
            component.processUpdates(context);
        }

        public void invokeRoot(FacesContext context) {
            AjaxViewRoot.super.processUpdates(context);
        }
    };
    private InvokerCallback _validatorsInvoker = new InvokerCallback(){

        public void invokeContextCallback(FacesContext context, UIComponent component) {
            component.processValidators(context);
        }

        public void invokeRoot(FacesContext context) {
            AjaxViewRoot.super.processValidators(context);
        }
    };
    private InvokerCallback _ajaxInvoker = new InvokerCallback(){

        public void invokeContextCallback(FacesContext context, UIComponent component) {
            try {
                if (component instanceof AjaxContainer) {
                    AjaxContainer ajax = (AjaxContainer)component;
                    ajax.encodeAjax(context);
                } else {
                    AjaxViewRoot.this.encodeAjax(context);
                }
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }

        public void invokeRoot(FacesContext context) {
            try {
                AjaxViewRoot.this.encodeAjax(context);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
    };

    public AjaxViewRoot() {
        super.setId(ROOT_ID);
        this._brige = new AjaxRegionBrige((UIComponent)this);
    }

    public String getRendererType() {
        return "javax.faces.ViewRoot";
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        this.getBrige().broadcast(event);
    }

    public MethodExpression getAjaxListener() {
        return this.getBrige().getAjaxListener();
    }

    public boolean isImmediate() {
        return this.getBrige().isImmediate();
    }

    public boolean isSubmitted() {
        return this.getBrige().isSubmitted();
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException(Messages.getMessage((String)"NULL_EVENT_SUBMITTED_ERROR"));
        }
        if (event.getPhaseId().compareTo((Object)PhaseId.RENDER_RESPONSE) == 0) {
            this.getAjaxEventsQueue(this.getFacesContext()).offer(event);
        } else {
            this.getEventsQueue(this.getFacesContext(), event.getPhaseId()).offer(event);
        }
    }

    void broadcastEvents(FacesContext context, PhaseId phaseId) {
        EventsQueue[] events = this.getEvents(context);
        EventsQueue anyPhaseEvents = events[PhaseId.ANY_PHASE.getOrdinal()];
        EventsQueue phaseEvents = events[phaseId.getOrdinal()];
        if (phaseEvents.isEmpty() && anyPhaseEvents.isEmpty()) {
            return;
        }
        boolean haveAnyPhaseEvents = !anyPhaseEvents.isEmpty();
        boolean havePhaseEvents = !phaseEvents.isEmpty();
        do {
            this.processEvents(anyPhaseEvents, haveAnyPhaseEvents);
            this.processEvents(phaseEvents, havePhaseEvents);
            haveAnyPhaseEvents = !anyPhaseEvents.isEmpty();
            boolean bl = havePhaseEvents = !phaseEvents.isEmpty();
        } while (haveAnyPhaseEvents || havePhaseEvents);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents(context);
        }
    }

    public void processEvents(EventsQueue phaseEventsQueue, boolean havePhaseEvents) {
        while (havePhaseEvents) {
            try {
                FacesEvent event = (FacesEvent)phaseEventsQueue.remove();
                UIComponent source = event.getComponent();
                try {
                    source.broadcast(event);
                }
                catch (AbortProcessingException e) {
                }
            }
            catch (NoSuchElementException e) {
                havePhaseEvents = false;
            }
        }
    }

    public void broadcastAjaxEvents(FacesContext context) {
        EventsQueue queue;
        this.processEvents(queue, !(queue = this.getAjaxEventsQueue(context)).isEmpty());
    }

    protected EventsQueue getEventsQueue(FacesContext context, PhaseId phase) {
        return this.getEvents(context)[phase.getOrdinal()];
    }

    protected EventsQueue[] getEvents(FacesContext context) {
        if (this.events == null) {
            this.clearEvents(context);
        }
        return this.events;
    }

    protected EventsQueue getAjaxEventsQueue(FacesContext context) {
        return this.ajaxEvents;
    }

    public void clearEvents(FacesContext context) {
        int len = PhaseId.VALUES.size();
        this.events = new EventsQueue[len];
        for (int i = 0; i < len; ++i) {
            this.events[i] = new EventsQueue();
        }
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        AjaxContextImpl.invokeOnRegionOrRoot(this, context, this._decodeInvoker);
        this.broadcastEvents(context, PhaseId.APPLY_REQUEST_VALUES);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        AjaxContextImpl.invokeOnRegionOrRoot(this, context, this._updatesInvoker);
        this.broadcastEvents(context, PhaseId.UPDATE_MODEL_VALUES);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        AjaxContextImpl.invokeOnRegionOrRoot(this, context, this._validatorsInvoker);
        this.broadcastEvents(context, PhaseId.PROCESS_VALIDATIONS);
    }

    public void processApplication(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.broadcastEvents(context, PhaseId.INVOKE_APPLICATION);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!this.isHavePage() && AjaxContext.getCurrentInstance((FacesContext)context).isAjaxRequest(context)) {
            AjaxContextImpl.invokeOnRegionOrRoot(this, context, this._ajaxInvoker);
        } else {
            super.encodeChildren(context);
        }
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] mystate = (Object[])state;
        super.restoreState(context, mystate[0]);
        this.getBrige().restoreState(context, mystate[1]);
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.getBrige().saveState(context)};
        return state;
    }

    public String getViewId() {
        ViewIdHolder viewIdHolder = AjaxContext.getCurrentInstance().getViewIdHolder();
        String viewId = null != viewIdHolder ? viewIdHolder.getViewId() : super.getViewId();
        return viewId;
    }

    public void setAjaxListener(MethodExpression ajaxListener) {
        this.getBrige().setAjaxListener(ajaxListener);
    }

    public void setImmediate(boolean immediate) {
        this.getBrige().setImmediate(immediate);
    }

    public void setSubmitted(boolean submitted) {
        this.getBrige().setSubmitted(submitted);
    }

    public void addAjaxListener(AjaxListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public AjaxListener[] getAjaxListeners() {
        return (AjaxListener[])this.getFacesListeners(AjaxListener.class);
    }

    public void removeAjaxListener(AjaxListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public boolean isSelfRendered() {
        return false;
    }

    public void setSelfRendered(boolean selfRendered) {
    }

    public boolean isHavePage() {
        return this.getChildCount() == 1 && this.getChildren().get(0) instanceof AjaxContainer;
    }

    public boolean getRendersChildren() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!AjaxContext.getCurrentInstance((FacesContext)context).isAjaxRequest(context)) {
            return false;
        }
        return !this.isHavePage();
    }

    public boolean isRenderRegionOnly() {
        return false;
    }

    public void setRenderRegionOnly(boolean reRenderPage) {
    }

    public String getSubmittedControlId() {
        return this._brige.getSubmittedControlId();
    }

    public void setSubmittedControlId(String submittedControlId) {
        this._brige.setSubmittedControlId(submittedControlId);
    }

    public void encodeAjax(FacesContext context) throws IOException {
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            ((AjaxContainerRenderer)this.getRenderer(context)).encodeAjax(context, (UIComponent)this);
        }
    }

    protected AjaxRegionBrige getBrige() {
        return this._brige;
    }
}

