/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.ajax4jsf.request.MultipartRequest;
import org.ajax4jsf.webapp.ConfigurableFilter;

public class Filter
extends ConfigurableFilter {
    public static final String MULTIPART = "multipart/";
    public static final String REQUESTS_SESSIONS_BEAN_NAME = "_richfaces_upload_sessions";
    public static final String PERCENT_BEAN_NAME = "_richfaces_upload_percents";
    public static final String UPLOAD_FILES_ID = "_richfaces_upload_uid";
    private boolean createTempFiles = false;
    private int maxRequestSize = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String uid = httpRequest.getParameter(UPLOAD_FILES_ID);
        if (uid != null) {
            if (this.isMultipartRequest(httpRequest)) {
                MultipartRequest multipartRequest = new MultipartRequest(httpRequest, this.createTempFiles, this.maxRequestSize, uid);
                Map<String, MultipartRequest> sessionsMap = null;
                HashMap<String, Integer> percentMap = null;
                try {
                    if (!this.isFileSizeRestricted(request, this.maxRequestSize)) {
                        HttpSession session;
                        HttpSession httpSession = session = httpRequest.getSession();
                        synchronized (httpSession) {
                            sessionsMap = (Map)session.getAttribute(REQUESTS_SESSIONS_BEAN_NAME);
                            percentMap = (Map)session.getAttribute(PERCENT_BEAN_NAME);
                            if (sessionsMap == null) {
                                sessionsMap = Collections.synchronizedMap(new HashMap());
                                session.setAttribute(REQUESTS_SESSIONS_BEAN_NAME, sessionsMap);
                            }
                            if (percentMap == null) {
                                percentMap = new HashMap<String, Integer>();
                                session.setAttribute(PERCENT_BEAN_NAME, percentMap);
                            }
                        }
                        percentMap.put(uid, 0);
                        sessionsMap.put(uid, multipartRequest);
                        if (multipartRequest.parseRequest()) {
                            super.doFilter((ServletRequest)multipartRequest, response, chain);
                        }
                        this.printResponse(response, "<html id=\"_richfaces_file_upload_stopped\"></html>");
                    }
                    this.printResponse(response, "<html id=\"_richfaces_file_upload_size_restricted\"></html>");
                }
                finally {
                    if (sessionsMap != null) {
                        sessionsMap.remove(uid);
                        percentMap.remove(uid);
                    }
                }
            } else if ("stop".equals(httpRequest.getParameter("action"))) {
                MultipartRequest multipartRequest;
                HttpSession session = httpRequest.getSession();
                Map sessions = (Map)session.getAttribute(REQUESTS_SESSIONS_BEAN_NAME);
                if (sessions != null && (multipartRequest = (MultipartRequest)((Object)sessions.get(uid))) != null) {
                    multipartRequest.stop();
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    httpResponse.setStatus(204);
                    httpResponse.getOutputStream().close();
                }
            } else {
                super.doFilter(request, response, chain);
            }
        } else {
            super.doFilter(request, response, chain);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String param = filterConfig.getInitParameter("createTempFiles");
        this.createTempFiles = param != null ? Boolean.parseBoolean(param) : true;
        param = filterConfig.getInitParameter("maxRequestSize");
        if (param != null) {
            this.maxRequestSize = Integer.parseInt(param);
        }
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    private boolean isFileSizeRestricted(ServletRequest request, int maxSize) {
        return maxSize != 0 && request.getContentLength() > maxSize;
    }

    private void printResponse(ServletResponse response, String message) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setStatus(200);
        httpResponse.setContentType("text/html");
        PrintWriter writer = httpResponse.getWriter();
        writer.write(message);
        writer.close();
    }
}

