/**
 * 
 */
package org.ajax4jsf.application;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/**
 * @author asmirnov
 *
 */
final class TreeStrutureNode implements Externalizable {
	/**
	 * TODO - implement Externalizable to reduce serialized state.
	 */
	private static final long serialVersionUID = -9038742487716977911L;

	private static final String NULL_ID = "";

	private Map<String, TreeStrutureNode> facets = null;

	private List<TreeStrutureNode> children = null;

	private String type;

	private String id;

	public TreeStrutureNode() {
	}

	public void apply(FacesContext context, UIComponent component,
			Set<String> uniqueIds) {
		type = component.getClass().getName();
		id = component.getId();
		String clientId = component.getClientId(context);
		if (!uniqueIds.add(clientId)) {
			throw new IllegalStateException("duplicate Id for a component "
					+ clientId);
		}
		Map<String, UIComponent> componentFacets = component.getFacets();
		for (Iterator<Entry<String,UIComponent>> i = componentFacets.entrySet().iterator(); i
				.hasNext();) {
			Entry<String,UIComponent> element = i.next();
			UIComponent f = (UIComponent) element.getValue();
			if (!f.isTransient()) {
				TreeStrutureNode facet = new TreeStrutureNode();
				facet.apply(context, f, uniqueIds);
				if (null == facets) {
					facets = new HashMap();
				}
				facets.put(element.getKey(), facet);

			}
		}
		for (Iterator i = component.getChildren().iterator(); i.hasNext();) {
			UIComponent child = (UIComponent) i.next();
			if (!child.isTransient()) {
				TreeStrutureNode t = new TreeStrutureNode();
				t.apply(context, child, uniqueIds);
				if (null == children) {
					children = new ArrayList();
				}
				children.add(t);

			}
		}
	}

	public UIComponent restore(ComponentsLoader loader) {
		UIComponent component;
		component = loader.createComponent(type);
		component.setId(id);
		if (null != facets) {
			for (Iterator<Entry<String, TreeStrutureNode>> i = facets.entrySet().iterator(); i.hasNext();) {
				Entry<String, TreeStrutureNode> element =  i.next();
				UIComponent facet = ( element.getValue())
						.restore(loader);
				component.getFacets().put(element.getKey(), facet);
			}

		}
		if (null != children) {
			for (Iterator i = children.iterator(); i.hasNext();) {
				TreeStrutureNode node = (TreeStrutureNode) i.next();
				UIComponent child = node.restore(loader);
				component.getChildren().add(child);
			}

		}
		return component;
	}

	/**
	 * @return the facets
	 */
	public Map getFacets() {
		return facets;
	}

	/**
	 * @param facets
	 *            the facets to set
	 */
	public void setFacets(Map facets) {
		this.facets = facets;
	}

	/**
	 * @return the children
	 */
	public List getChildren() {
		return children;
	}

	/**
	 * @param children
	 *            the children to set
	 */
	public void setChildren(List children) {
		this.children = children;
	}

	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param type
	 *            the type to set
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	public void readExternal(ObjectInput in) throws IOException,
			ClassNotFoundException {
		type = in.readUTF();
		id = in.readUTF();
		if (NULL_ID.equals(id)) {
			id = null;
		}
		int facetsSize = in.readInt();
		if (facetsSize > 0) {
			facets = new HashMap(facetsSize);
			for (int i = 0; i < facetsSize; i++) {
				String facetName = in.readUTF();
				TreeStrutureNode facet = new TreeStrutureNode();
				facet.readExternal(in);
				facets.put(facetName, facet);
			}
		}
		int childrenSize = in.readInt();
		if (childrenSize > 0) {
			children = new ArrayList(childrenSize);
			for (int i = 0; i < childrenSize; i++) {
				TreeStrutureNode child = new TreeStrutureNode();
				child.readExternal(in);
				children.add(child);
			}
		}
	}

	public void writeExternal(ObjectOutput out) throws IOException {
		out.writeUTF(type);
		out.writeUTF(null == id ? NULL_ID : id);
		if (null != facets) {
			out.writeInt(facets.size());
			for (Iterator i = facets.entrySet().iterator(); i.hasNext();) {
				Map.Entry entry = (Map.Entry) i.next();
				out.writeUTF((String) entry.getKey());
				TreeStrutureNode node = (TreeStrutureNode) entry.getValue();
				node.writeExternal(out);
			}

		} else {
			out.writeInt(0);
		}
		if (null != children) {
			out.writeInt(children.size());
			for (Iterator i = children.iterator(); i.hasNext();) {
				TreeStrutureNode child = (TreeStrutureNode) i.next();
				child.writeExternal(out);
			}

		} else {
			out.writeInt(0);
		}
	}
}