/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.org.w3c.tidy.EntityTable;
import org.ajax4jsf.renderkit.AjaxChildrenRenderer;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.renderkit.AttributeParametersEncoder;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;

public abstract class CompositeRenderer
extends AjaxChildrenRenderer {
    private List renderers = new ArrayList();
    private List parameterEncoders = new ArrayList();
    private final Command DECODE_COMMAND = new Command(){

        protected void execute(RendererContributor renderer, FacesContext context, UIComponent component, Object argument) {
            renderer.decode(context, component, CompositeRenderer.this);
        }
    };
    private static final Command MERGE_OPTIONS_COMMAND = new Command(){

        protected void execute(RendererContributor renderer, FacesContext context, UIComponent component, Object argument) {
            ScriptOptions initialOptions = (ScriptOptions)((Object)argument);
            ScriptOptions builtOptions = renderer.buildOptions(context, component);
            if (builtOptions != null) {
                initialOptions.merge(builtOptions);
            }
        }
    };
    private static final Command MERGE_STYLE_DEPENDENCIES = new Command(){

        protected void execute(RendererContributor renderer, FacesContext facesContext, UIComponent component, Object argument) {
            String[] styleDependencies = renderer.getStyleDependencies();
            if (styleDependencies != null) {
                Set styles = (Set)argument;
                for (int i = 0; i < styleDependencies.length; ++i) {
                    styles.add(styleDependencies[i]);
                }
            }
        }
    };
    private static final Command MERGE_SCRIPT_DEPENDENCIES = new Command(){

        protected void execute(RendererContributor renderer, FacesContext facesContext, UIComponent component, Object argument) {
            String[] scriptDependencies = renderer.getScriptDependencies();
            if (scriptDependencies != null) {
                Set scripts = (Set)argument;
                for (int i = 0; i < scriptDependencies.length; ++i) {
                    scripts.add(scriptDependencies[i]);
                }
            }
        }
    };
    private static final Command GET_SCRIPT_CONTRIBUTIONS = new Command(){

        protected void execute(RendererContributor renderer, FacesContext context, UIComponent component, Object argument) {
            String contribution = renderer.getScriptContribution(context, component);
            if (contribution != null) {
                ((List)argument).add(contribution);
            }
        }
    };

    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        this.DECODE_COMMAND.execute(this.renderers.iterator(), context, component, null, component.getClass());
    }

    protected void mergeScriptOptions(ScriptOptions scriptOptions, FacesContext context, UIComponent component) {
        this.mergeScriptOptions(scriptOptions, context, component, null);
    }

    protected void mergeScriptOptions(ScriptOptions scriptOptions, FacesContext context, UIComponent component, Class acceptableClass) {
        MERGE_OPTIONS_COMMAND.execute(this.renderers.iterator(), context, component, (Object)scriptOptions, acceptableClass);
    }

    protected InternetResource[] getScripts() {
        return this.getResources(null, MERGE_SCRIPT_DEPENDENCIES);
    }

    protected InternetResource[] getStyles() {
        return this.getResources(null, MERGE_STYLE_DEPENDENCIES);
    }

    protected InternetResource[] getScripts(Class clazz) {
        return this.getResources(clazz, MERGE_SCRIPT_DEPENDENCIES);
    }

    protected InternetResource[] getStyles(Class clazz) {
        return this.getResources(clazz, MERGE_STYLE_DEPENDENCIES);
    }

    private InternetResource[] getResources(Class acceptableClass, Command command) {
        LinkedHashSet scriptsSet = new LinkedHashSet();
        command.execute(this.renderers.iterator(), null, null, scriptsSet, acceptableClass);
        if (!scriptsSet.isEmpty()) {
            Iterator iterator = scriptsSet.iterator();
            InternetResource[] result = new InternetResource[scriptsSet.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.getResource((String)iterator.next());
            }
            return result;
        }
        return null;
    }

    protected String getScriptContributions(String varString, FacesContext context, UIComponent component) {
        return this.getScriptContributions(varString, context, component, component.getClass());
    }

    protected String getScriptContributions(String varString, FacesContext context, UIComponent component, Class acceptableClass) {
        ArrayList scriptContributions = new ArrayList();
        GET_SCRIPT_CONTRIBUTIONS.execute(this.renderers.iterator(), context, component, scriptContributions, acceptableClass);
        StringBuffer result = new StringBuffer();
        Iterator itr = scriptContributions.iterator();
        while (itr.hasNext()) {
            result.append(varString);
            result.append(itr.next());
        }
        return result.toString();
    }

    protected void addContributor(RendererContributor renderer) {
        this.renderers.add(renderer);
    }

    protected RendererContributor[] getContributors() {
        return this.renderers.toArray(new RendererContributor[this.renderers.size()]);
    }

    public void contributorDecodeCallback(UIComponent component, FacesContext context, RendererContributor contributor, Object argument) {
    }

    protected void addParameterEncoder(AttributeParametersEncoder encoder) {
        this.parameterEncoders.add(encoder);
    }

    protected AttributeParametersEncoder[] getParameterEncoders() {
        return this.parameterEncoders.toArray(new AttributeParametersEncoder[this.renderers.size()]);
    }

    public void encodeAttributeParameters(FacesContext context, UIComponent component) throws IOException {
        for (AttributeParametersEncoder encoder : this.parameterEncoders) {
            encoder.doEncode(context, component);
        }
    }

    protected String escapeHtmlEntities(CharSequence orig) {
        StringBuffer buff = new StringBuffer(orig);
        EntityTable defaultEntityTable = EntityTable.getDefaultEntityTable();
        Matcher matcher = Pattern.compile("\\&\\w+\\;").matcher(orig);
        int delta = 0;
        while (matcher.find()) {
            String name = matcher.group().substring(0, matcher.group().length() - 1);
            int code = defaultEntityTable.entityCode(name);
            if (0 == code) continue;
            String replacement = "&#" + code + ";";
            buff.replace(matcher.start() - delta, matcher.end() - delta, replacement);
            delta = delta + matcher.group().length() - replacement.length();
        }
        return buff.toString();
    }

    private static abstract class Command {
        private Command() {
        }

        protected final void execute(Iterator renderers, FacesContext facesContext, UIComponent component, Object argument, Class clazz) {
            while (renderers.hasNext()) {
                RendererContributor contributor = (RendererContributor)renderers.next();
                Class acceptableClass = contributor.getAcceptableClass();
                if (clazz != null && acceptableClass != null && !acceptableClass.isAssignableFrom(clazz)) continue;
                this.execute(contributor, facesContext, component, argument);
            }
        }

        protected abstract void execute(RendererContributor var1, FacesContext var2, UIComponent var3, Object var4);
    }
}

