/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.Messages;
import org.ajax4jsf.webapp.BaseFilter;
import org.ajax4jsf.webapp.FilterServletResponseWrapper;
import org.ajax4jsf.webapp.HtmlParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseXMLFilter {
    private static final Log log = LogFactory.getLog((Class)(class$org$ajax4jsf$webapp$BaseXMLFilter == null ? (class$org$ajax4jsf$webapp$BaseXMLFilter = BaseXMLFilter.class$("org.ajax4jsf.webapp.BaseXMLFilter")) : class$org$ajax4jsf$webapp$BaseXMLFilter));
    public static final String RESPONSE_WRAPPER_ATTRIBUTE = "com.exade.vcp.Filter.ResponseWrapper";
    private String mimetype = "text/xml";
    private String publicid = "-//W3C//DTD XHTML 1.0 Transitional//EN";
    private String systemid = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    private String namespace = "http://www.w3.org/1999/xhtml";
    private static final String MIME_TYPE_PARAMETER = "mime-type";
    private static final String PUBLICID_PARAMETER = "publicid";
    private static final String SYSTEMID_PARAMETER = "systemid";
    private static final String NAMESPACE_PARAMETER = "namespace";
    private boolean forcexml = false;
    private static final String FORCEXML_PARAMETER = "forceparser";
    private static final String INIT_PARAMETER_PREFIX = "org.ajax4jsf.xmlfilter.";
    public static final String TEXT_HTML = "text/html";
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    public BaseFilter filter;
    static /* synthetic */ Class class$org$ajax4jsf$webapp$BaseXMLFilter;

    public void setFilter(BaseFilter filter) {
        this.filter = filter;
    }

    public void init(FilterConfig config) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init XML filter service with class " + this.getClass().getName()));
        }
        String forceXmlParameter = config.getInitParameter(FORCEXML_PARAMETER);
        this.setupForceXml(forceXmlParameter);
        forceXmlParameter = config.getServletContext().getInitParameter("org.ajax4jsf.xmlfilter.forceparser");
        this.setMimetype((String)this.nz(config.getInitParameter(MIME_TYPE_PARAMETER), "text/xml"));
        this.setPublicid((String)this.nz(config.getInitParameter(PUBLICID_PARAMETER), this.getPublicid()));
        this.setSystemid((String)this.nz(config.getInitParameter(SYSTEMID_PARAMETER), this.getSystemid()));
        this.setNamespace((String)this.nz(config.getInitParameter(NAMESPACE_PARAMETER), this.getNamespace()));
    }

    private void setupForceXml(String forceXmlParameter) {
        if ("false".equalsIgnoreCase(forceXmlParameter)) {
            this.forcexml = false;
        }
        if ("true".equalsIgnoreCase(forceXmlParameter)) {
            this.forcexml = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doXmlFilter(FilterChain chain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Writer output;
        if (log.isDebugEnabled()) {
            log.debug((Object)"XML filter service start processing request");
        }
        FilterServletResponseWrapper servletResponseWrapper = this.getWrapper(response);
        try {
            request.setAttribute(RESPONSE_WRAPPER_ATTRIBUTE, (Object)servletResponseWrapper);
            chain.doFilter((ServletRequest)request, (ServletResponse)servletResponseWrapper);
        }
        finally {
            request.removeAttribute(RESPONSE_WRAPPER_ATTRIBUTE);
        }
        String viewId = (String)request.getAttribute("org.ajax4jsf.VIEW_ID");
        HtmlParser parser = null;
        String redirectLocation = servletResponseWrapper.getRedirectLocation();
        String characterEncoding = servletResponseWrapper.getCharacterEncoding();
        Object view_expired = request.getAttribute("org.ajax4jsf.view.EXPIRED");
        if (null != view_expired) {
            servletResponseWrapper.setHeader("Ajax-Expired", view_expired.toString());
        }
        if (null != redirectLocation) {
            if (this.isAjaxRequest((ServletRequest)request)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Create AJAX redirect response to url: " + redirectLocation));
                }
                response.reset();
                Iterator iter = servletResponseWrapper.getCookies().iterator();
                while (iter.hasNext()) {
                    Cookie cookie = (Cookie)iter.next();
                    response.addCookie(cookie);
                }
                Map headers = servletResponseWrapper.getHeaders();
                Iterator iter2 = headers.entrySet().iterator();
                while (iter2.hasNext()) {
                    Map.Entry header = iter2.next();
                    response.setHeader((String)header.getKey(), (String)header.getValue());
                }
                response.setHeader("Ajax-Response", "redirect");
                response.setHeader("Cache-Control", "no-cache, must-revalidate, max_age=0, no-store");
                response.setHeader("Expires", "0");
                response.setHeader("Pragma", "no-cache");
                response.setContentType(this.getMimetype() + ";charset=UTF-8");
                response.setHeader("Location", redirectLocation);
                Writer output2 = this.createResponseWriter(response, "UTF-8");
                output2.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta name=\"Ajax-Response\" content=\"redirect\" /><meta name=\"Location\" content=\"" + redirectLocation + "\" />" + "</head></html>");
                output2.flush();
                response.flushBuffer();
            } else {
                response.sendRedirect(redirectLocation);
            }
            return;
        }
        if ("true".equals(servletResponseWrapper.getHeaders().get("Ajax-Response"))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Process response to well-formed XML for AJAX XMLHttpRequest parser");
            }
            response.setHeader("Cache-Control", "no-cache, must-revalidate, max_age=0, no-store");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "no-cache");
            String outputEncoding = "UTF-8";
            String contentType = this.getMimetype() + ";charset=" + outputEncoding;
            response.setContentType(contentType);
            parser = this.getParser(this.getMimetype(), true, viewId);
            if (null == parser) {
                throw new ServletException(Messages.getMessage((String)"PARSER_NOT_INSTANTIATED_ERROR", (Object)contentType));
            }
            output = this.createResponseWriter(response, outputEncoding);
            parser.setDoctype(this.getPublicid());
            parser.setInputEncoding(characterEncoding);
            parser.setOutputEncoding(outputEncoding);
            parser.setViewState((String)request.getAttribute("org.ajax4jsf.view.serializedstate"));
        } else {
            String contentType = servletResponseWrapper.getContentType();
            if (log.isDebugEnabled()) {
                log.debug((Object)("create HTML/XML parser for content type: " + contentType));
            }
            if (contentType != null) {
                if (contentType.indexOf("charset") < 0 && null != characterEncoding) {
                    contentType = contentType + ";charset=" + characterEncoding;
                }
                parser = this.getParser(contentType, false, viewId);
                response.setContentType(contentType);
            }
            if (null == parser) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Parser not have support for the such content type, send response as-is");
                }
                if (servletResponseWrapper.isUseWriter()) {
                    Writer output3 = this.createResponseWriter(response, characterEncoding);
                    servletResponseWrapper.sendContent(output3);
                } else if (servletResponseWrapper.isUseStream()) {
                    ServletOutputStream out = response.getOutputStream();
                    servletResponseWrapper.sendContent(out);
                }
                return;
            }
            output = this.createResponseWriter(response, characterEncoding);
            parser.setInputEncoding(characterEncoding);
            parser.setOutputEncoding(characterEncoding);
        }
        try {
            parser.setScripts((Set)request.getAttribute("org.ajax4jsf.framework.HEADER_SCRIPTS"));
            parser.setStyles((Set)request.getAttribute("org.ajax4jsf.framework.HEADER_STYLES"));
            parser.setUserStyles((Set)request.getAttribute("org.ajax4jsf.framework.HEADER_USER_STYLES"));
            long startTimeMills = System.currentTimeMillis();
            servletResponseWrapper.parseContent(output, parser);
            if (log.isDebugEnabled()) {
                startTimeMills = System.currentTimeMillis() - startTimeMills;
                log.debug((Object)Messages.getMessage((String)"PARSING_TIME_INFO", (Object)("" + startTimeMills)));
            }
        }
        catch (Exception e) {
            throw new ServletException(Messages.getMessage((String)"JTIDY_PARSING_ERROR"), (Throwable)e);
        }
        finally {
            this.reuseParser(parser);
        }
    }

    protected FilterServletResponseWrapper getWrapper(HttpServletResponse response) throws ServletException {
        return new FilterServletResponseWrapper(response);
    }

    protected boolean isAjaxRequest(ServletRequest request) {
        try {
            return null != request.getParameter("AJAXREQUEST");
        }
        catch (Exception e) {
            return false;
        }
    }

    private Writer createResponseWriter(HttpServletResponse response, String characterEncoding) throws IOException, UnsupportedEncodingException {
        Writer output;
        try {
            output = response.getWriter();
        }
        catch (IllegalStateException e) {
            output = null != characterEncoding ? new OutputStreamWriter((OutputStream)response.getOutputStream(), characterEncoding) : new OutputStreamWriter((OutputStream)response.getOutputStream());
        }
        return output;
    }

    protected abstract void reuseParser(HtmlParser var1);

    protected abstract HtmlParser getParser(String var1, boolean var2, String var3);

    protected void setPublicid(String publicid) {
        this.publicid = publicid;
    }

    public String getPublicid() {
        return this.publicid;
    }

    protected void setSystemid(String systemid) {
        this.systemid = systemid;
    }

    public String getSystemid() {
        return this.systemid;
    }

    protected void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    protected void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    protected String getMimetype() {
        return this.mimetype;
    }

    public boolean isForcexml() {
        return this.forcexml;
    }

    protected void setForcexml(boolean forcexml) {
        this.forcexml = forcexml;
    }

    private Object nz(Object param, Object def) {
        return param != null ? param : def;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

