/**
 * License Agreement.
 *
 * Rich Faces - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.skin;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

import org.richfaces.skin.Skin;

/**
 * Singleton ( in respect as collection of different skins ) for produce
 * instances properties for all used skins.
 * 
 * @author shura (latest modification by $Author: alexsmirnov $)
 * @version $Revision: 1.1.2.1 $ $Date: 2007/01/09 18:59:41 $
 * 
 */
public class SkinImpl implements Skin {


	public static final String RENDER_KIT_PARAMETER = "render.kit";
	
	public static final String REQUEST_HASH_CODE_PARAMETER = "org.ajax4jsf.skin.HASH_CODE"; 

	private Map skinParams = new HashMap();
	

	/**
	 * Skin can instantiate only by factory method.
	 * 
	 * @param skinName
	 */
	SkinImpl(Map properties) {
		skinParams = properties;
	}


	/* (non-Javadoc)
	 * @see org.richfaces.skin.Skin#getRenderKitId(javax.faces.context.FacesContext)
	 */
	public String getRenderKitId(FacesContext context) {
		return (String) getValueReference(context,skinParams.get(RENDER_KIT_PARAMETER));
	}

	/* (non-Javadoc)
	 * @see org.richfaces.skin.Skin#getParameter(javax.faces.context.FacesContext, java.lang.String)
	 */
	public Object getParameter(FacesContext context, String name) {
		return getValueReference(context,skinParams.get(name));
	}

	/* (non-Javadoc)
	 * @see org.richfaces.skin.Skin#getParameter(javax.faces.context.FacesContext, java.lang.String, java.lang.String, java.lang.Object)
	 */
	public Object getParameter(FacesContext context, String name,  Object defaultValue) {
		Object value = getValueReference(context, skinParams.get(name));
		if(null == value){
			value = defaultValue;
		}
		return value;
	}
	
	
	/**
	 * Calculate concrete value for property - if it stored as @see ValueBinding ,
	 * return interpreted value.
	 * @param context
	 * @param property
	 * @return
	 */
	private Object getValueReference(FacesContext context, Object property) {
		if (property instanceof ValueBinding) {
			ValueBinding value = (ValueBinding) property;
			return value.getValue(context);
		}
		return property;
	}


	public String toString() {
		return skinParams.toString();
	}


	/* (non-Javadoc)
	 * @see org.richfaces.skin.Skin#containsProperty(java.lang.String)
	 */
	public boolean containsProperty(String name) {
		// TODO Auto-generated method stub
		return skinParams.containsKey(name);
	}


	/* (non-Javadoc)
	 * @see org.richfaces.skin.Skin#hashCode(javax.faces.context.FacesContext)
	 */
	public int hashCode(FacesContext context) {
		Integer requestCode = (Integer) context.getExternalContext().getRequestMap().get(REQUEST_HASH_CODE_PARAMETER);
		if(null == requestCode){
			int hash = 0;
			for (Iterator iter = skinParams.keySet().iterator(); iter.hasNext();) {
				String key = (String) iter.next();
				Object parameter = getParameter(context,key);
				hash = 31*hash + (parameter != null ? parameter.hashCode() : 0);
			}
			requestCode = new Integer(hash);
			// store hash for this skin as request-skope parameter - not calculate on next calls for same request
			context.getExternalContext().getRequestMap().put(REQUEST_HASH_CODE_PARAMETER,requestCode);
		}
		return requestCode.intValue();
	}
	
	

}
