/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.example;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.faces.FacesException;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.richfaces.example.PageDescriptionBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedBean
@ApplicationScoped
public class Pages {
    public static final String DEFAULT_TITLE_PATTERN = "<ui\\:param\\s+name=\"title\"\\s+value=\"([^\"]*)\"";
    private static final Pattern XHTML_PATTERN = Pattern.compile(".*\\.xhtml");
    private static final Pattern PARENT_FOLDER_PATTERN = Pattern.compile("(/.*/.*/).*\\.xhtml");
    private static final Pattern FOLDER_PATTERN = Pattern.compile(".*/$");
    private static final String EXAMPLE_PATH = "/examples";
    private Pattern titlePattern = this.compilePattern("<ui\\:param\\s+name=\"title\"\\s+value=\"([^\"]*)\"");
    private Map<String, List<PageDescriptionBean>> pageFolderMap;
    private List<PageDescriptionBean> indexPages;

    public Pattern compilePattern(String titlePattern) {
        return Pattern.compile(titlePattern, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        this.pageFolderMap = new HashMap();
        Set resourcePaths = this.getExternalContext().getResourcePaths(EXAMPLE_PATH);
        this.indexPages = new ArrayList(resourcePaths.size());
        for (String folderPath : resourcePaths) {
            if (!FOLDER_PATTERN.matcher(folderPath).matches() && !new File(folderPath).isDirectory()) continue;
            String resourcePath = this.resourcePath(folderPath);
            this.pageFolderMap.put(resourcePath, this.getPagesByPattern(XHTML_PATTERN, resourcePath));
            String title = resourcePath;
            try {
                title = resourcePath.split("/")[2];
                title = this.firstChartToUppercase(title);
            }
            finally {
                this.indexPages.add(new PageDescriptionBean(resourcePath + "index.jsf", title));
            }
        }
        this.indexPages.addAll(this.getPagesByPattern(XHTML_PATTERN, EXAMPLE_PATH));
        Collections.sort(this.indexPages);
    }

    private String resourcePath(String fullPath) {
        boolean isDirectory = new File(fullPath).isDirectory();
        int i = fullPath.indexOf(EXAMPLE_PATH);
        String path = fullPath.substring(i);
        if (isDirectory && !path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    private String firstChartToUppercase(String string) {
        char[] chars = string.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private ExternalContext getExternalContext() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = null;
        if (null != facesContext) {
            externalContext = facesContext.getExternalContext();
        }
        return externalContext;
    }

    public List<PageDescriptionBean> getXhtmlPages() {
        String viewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
        Matcher m = PARENT_FOLDER_PATTERN.matcher(viewId);
        if (!m.find()) {
            return this.indexPages;
        }
        String path = m.group(1);
        return (List)this.pageFolderMap.get(path);
    }

    private List<PageDescriptionBean> getPagesByPattern(Pattern pattern, String path) {
        ArrayList<PageDescriptionBean> pageList = new ArrayList<PageDescriptionBean>();
        Set resourcePaths = this.getExternalContext().getResourcePaths(path);
        Iterator iterator = resourcePaths.iterator();
        while (iterator.hasNext()) {
            String page = this.resourcePath((String)iterator.next());
            if (!pattern.matcher(page).matches() || page.endsWith("/index.xhtml")) continue;
            InputStream pageInputStream = this.getExternalContext().getResourceAsStream(page);
            String title = page;
            if (null != pageInputStream) {
                byte[] head = new byte[2048];
                try {
                    Matcher titleMatcher;
                    int readed = pageInputStream.read(head);
                    String headString = new String(head, 0, readed);
                    if (title.endsWith("input/")) {
                        System.out.println(headString);
                    }
                    if ((titleMatcher = this.titlePattern.matcher(headString)).find() && titleMatcher.group(1).length() > 0) {
                        title = titleMatcher.group(1);
                    }
                }
                catch (IOException e) {
                    throw new FacesException("can't read directory content", (Throwable)e);
                }
                finally {
                    try {
                        pageInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            pageList.add(new PageDescriptionBean(page, title));
        }
        Collections.sort(pageList);
        return pageList;
    }

    public void setTitlePattern(String titlePattern) {
        this.titlePattern = this.compilePattern(titlePattern);
    }

    public String getTitlePattern() {
        return this.titlePattern.toString();
    }
}

