/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.example;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.richfaces.example.PageDescriptionBean;

public class Pages {
    public static final String DEFAULT_TITLE_PATTERN = "<ui\\:param\\s+name=\"title\"\\s+value=\"([^\"]*)\"";
    private static final Pattern JSP_PATTERN = Pattern.compile(".*\\.jspx?");
    private static final Pattern XHTML_PATTERN = Pattern.compile(".*\\.xhtml");
    private Pattern titlePattern = this.compilePattern("<ui\\:param\\s+name=\"title\"\\s+value=\"([^\"]*)\"");
    private volatile List<PageDescriptionBean> jspPages;
    private Object jspMutex = new Object();
    private String path = "/examples";
    private volatile List<PageDescriptionBean> xhtmlPages;
    private Object xhtmlMutex = new Object();

    public String getPath() {
        return this.path;
    }

    public Pattern compilePattern(String titlePattern) {
        return Pattern.compile(titlePattern, 10);
    }

    public void setPath(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PageDescriptionBean> getJspPages() {
        if (this.jspPages == null && null != this.getExternalContext()) {
            Object object = this.jspMutex;
            synchronized (object) {
                if (this.jspPages == null) {
                    this.jspPages = this.getPagesByPattern(JSP_PATTERN);
                }
            }
        }
        return this.jspPages;
    }

    private ExternalContext getExternalContext() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = null;
        if (null != facesContext) {
            externalContext = facesContext.getExternalContext();
        }
        return externalContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PageDescriptionBean> getXhtmlPages() {
        if (this.xhtmlPages == null && null != this.getExternalContext()) {
            Object object = this.xhtmlMutex;
            synchronized (object) {
                if (this.xhtmlPages == null) {
                    this.xhtmlPages = this.getPagesByPattern(XHTML_PATTERN);
                }
            }
        }
        return this.xhtmlPages;
    }

    private List<PageDescriptionBean> getPagesByPattern(Pattern pattern) {
        ArrayList<PageDescriptionBean> jspPages = new ArrayList<PageDescriptionBean>();
        Set resourcePaths = this.getExternalContext().getResourcePaths(this.getPath());
        for (String page : resourcePaths) {
            if (!pattern.matcher(page).matches()) continue;
            PageDescriptionBean pageBean = new PageDescriptionBean();
            pageBean.setPath(page);
            InputStream pageInputStream = this.getExternalContext().getResourceAsStream(page);
            if (null != pageInputStream) {
                byte[] head = new byte[1024];
                try {
                    int readed = pageInputStream.read(head);
                    String headString = new String(head, 0, readed);
                    Matcher titleMatcher = this.titlePattern.matcher(headString);
                    if (titleMatcher.find() && titleMatcher.group(1).length() > 0) {
                        pageBean.setTitle(titleMatcher.group(1));
                    } else {
                        pageBean.setTitle(page);
                    }
                }
                catch (IOException e) {
                    throw new FacesException("can't read directory content", (Throwable)e);
                }
                finally {
                    try {
                        pageInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            jspPages.add(pageBean);
        }
        Collections.sort(jspPages);
        return jspPages;
    }

    public void setTitlePattern(String titlePattern) {
        this.titlePattern = this.compilePattern(titlePattern);
    }

    public String getTitlePattern() {
        return this.titlePattern.toString();
    }
}

