/*
 * JBoss, Home of Professional Open Source
 * Copyright 2013, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.richfaces.demo.queue;

import java.io.Serializable;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;

@ManagedBean
@ViewScoped
public class QueueBean implements Serializable {
    /**
     *
     */
    private static final long serialVersionUID = 7503791626510224913L;
    private Long requestDelay = new Long(500);
    private boolean ignoreDupResponces = false;
    private String text = "";
    private int requests = 0;
    private int events = 0;

    public void resetText() {
        setText("");
    }

    public Long getRequestDelay() {
        return requestDelay;
    }

    public void setRequestDelay(Long requestDelay) {
        this.requestDelay = requestDelay;
    }

    public boolean isIgnoreDupResponces() {
        return ignoreDupResponces;
    }

    public void setIgnoreDupResponces(boolean ignoreDupResponces) {
        this.ignoreDupResponces = ignoreDupResponces;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getRequests() {
        return requests;
    }

    public void setRequests(int reuqests) {
        this.requests = reuqests;
    }

    public int getEvents() {
        return events;
    }

    public void setEvents(int events) {
        this.events = events;
    }
}
