/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo.tables;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.model.SelectItem;
import org.richfaces.demo.common.data.RandomHelper;
import org.richfaces.demo.tables.model.cars.InventoryItem;
import org.richfaces.demo.tables.model.cars.InventoryVendorItem;
import org.richfaces.demo.tables.model.cars.InventoryVendorList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedBean(name="carsBean")
@SessionScoped
public class CarsBean
implements Serializable {
    private static final long serialVersionUID = -3832235132261771583L;
    private static final int DECIMALS = 1;
    private static final int ROUNDING_MODE = 4;
    private List<InventoryItem> allInventoryItems = null;
    private List<InventoryVendorList> inventoryVendorLists = null;

    public List<SelectItem> getVendorOptions() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        result.add(new SelectItem((Object)"", ""));
        for (InventoryVendorList vendorList : this.getInventoryVendorLists()) {
            result.add(new SelectItem((Object)vendorList.getVendor()));
        }
        return result;
    }

    public List<String> getAllVendors() {
        ArrayList<String> result = new ArrayList<String>();
        for (InventoryVendorList vendorList : this.getInventoryVendorLists()) {
            result.add(vendorList.getVendor());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryVendorList> getInventoryVendorLists() {
        CarsBean carsBean = this;
        synchronized (carsBean) {
            if (this.inventoryVendorLists == null) {
                this.inventoryVendorLists = new ArrayList();
                List inventoryItems = this.getAllInventoryItems();
                Collections.sort(inventoryItems, new /* Unavailable Anonymous Inner Class!! */);
                Iterator iterator = inventoryItems.iterator();
                InventoryVendorList vendorList = new InventoryVendorList();
                vendorList.setVendor(((InventoryItem)inventoryItems.get(0)).getVendor());
                while (iterator.hasNext()) {
                    InventoryItem item = (InventoryItem)iterator.next();
                    InventoryVendorItem newItem = new InventoryVendorItem();
                    this.itemToVendorItem(item, newItem);
                    if (!item.getVendor().equals(vendorList.getVendor())) {
                        this.inventoryVendorLists.add(vendorList);
                        vendorList = new InventoryVendorList();
                        vendorList.setVendor(item.getVendor());
                    }
                    vendorList.getVendorItems().add(newItem);
                }
                this.inventoryVendorLists.add(vendorList);
            }
        }
        return this.inventoryVendorLists;
    }

    private void itemToVendorItem(InventoryItem item, InventoryVendorItem newItem) {
        newItem.setActivity(item.getActivity());
        newItem.setChangePrice(item.getChangePrice());
        newItem.setChangeSearches(item.getChangeSearches());
        newItem.setDaysLive(item.getDaysLive());
        newItem.setExposure(item.getExposure());
        newItem.setInquiries(item.getInquiries());
        newItem.setMileage(item.getMileage());
        newItem.setMileageMarket(item.getMileageMarket());
        newItem.setModel(item.getModel());
        newItem.setPrice(item.getPrice());
        newItem.setPriceMarket(item.getPriceMarket());
        newItem.setPrinted(item.getPrinted());
        newItem.setStock(item.getStock());
        newItem.setVin(item.getVin());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryItem> getAllInventoryItems() {
        CarsBean carsBean = this;
        synchronized (carsBean) {
            if (this.allInventoryItems == null) {
                this.allInventoryItems = new ArrayList();
                for (int k = 0; k <= 5; ++k) {
                    try {
                        switch (k) {
                            case 0: {
                                this.allInventoryItems.addAll(this.createCar("Chevrolet", "Corvette", 5));
                                this.allInventoryItems.addAll(this.createCar("Chevrolet", "Malibu", 8));
                                this.allInventoryItems.addAll(this.createCar("Chevrolet", "Tahoe", 6));
                                break;
                            }
                            case 1: {
                                this.allInventoryItems.addAll(this.createCar("Ford", "Taurus", 12));
                                this.allInventoryItems.addAll(this.createCar("Ford", "Explorer", 11));
                                break;
                            }
                            case 2: {
                                this.allInventoryItems.addAll(this.createCar("Nissan", "Maxima", 9));
                                this.allInventoryItems.addAll(this.createCar("Nissan", "Frontier", 6));
                                break;
                            }
                            case 3: {
                                this.allInventoryItems.addAll(this.createCar("Toyota", "4-Runner", 7));
                                this.allInventoryItems.addAll(this.createCar("Toyota", "Camry", 15));
                                this.allInventoryItems.addAll(this.createCar("Toyota", "Avalon", 13));
                                break;
                            }
                            case 4: {
                                this.allInventoryItems.addAll(this.createCar("GMC", "Sierra", 8));
                                this.allInventoryItems.addAll(this.createCar("GMC", "Yukon", 10));
                                break;
                            }
                            case 5: {
                                this.allInventoryItems.addAll(this.createCar("Infiniti", "G35", 6));
                                this.allInventoryItems.addAll(this.createCar("Infiniti", "EX35", 5));
                                break;
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("!!!!!!loadallInventoryItems Error: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.allInventoryItems;
    }

    public List<InventoryItem> createCar(String vendor, String model, int count) {
        ArrayList<InventoryItem> iiList = null;
        try {
            int arrayCount = count;
            InventoryItem[] demoInventoryItemArrays = new InventoryItem[arrayCount];
            for (int j = 0; j < demoInventoryItemArrays.length; ++j) {
                InventoryItem ii = new InventoryItem();
                ii.setVendor(vendor);
                ii.setModel(model);
                ii.setStock(RandomHelper.randomstring((int)6, (int)7));
                ii.setVin(RandomHelper.randomstring((int)14, (int)15));
                ii.setMileage(new BigDecimal(RandomHelper.rand((int)5000, (int)80000)).setScale(1, 4));
                ii.setMileageMarket(new BigDecimal(RandomHelper.rand((int)25000, (int)45000)).setScale(1, 4));
                ii.setPrice(new Integer(RandomHelper.rand((int)15000, (int)55000)));
                ii.setPriceMarket(new BigDecimal(RandomHelper.rand((int)15000, (int)55000)).setScale(1, 4));
                ii.setDaysLive(RandomHelper.rand((int)1, (int)90));
                ii.setChangeSearches(new BigDecimal(RandomHelper.rand((int)0, (int)5)).setScale(1, 4));
                ii.setChangePrice(new BigDecimal(RandomHelper.rand((int)0, (int)5)).setScale(1, 4));
                ii.setExposure(new BigDecimal(RandomHelper.rand((int)0, (int)5)).setScale(1, 4));
                ii.setActivity(new BigDecimal(RandomHelper.rand((int)0, (int)5)).setScale(1, 4));
                ii.setPrinted(new BigDecimal(RandomHelper.rand((int)0, (int)5)).setScale(1, 4));
                ii.setInquiries(new BigDecimal(RandomHelper.rand((int)0, (int)5)).setScale(1, 4));
                demoInventoryItemArrays[j] = ii;
            }
            iiList = new ArrayList<InventoryItem>(Arrays.asList(demoInventoryItemArrays));
        }
        catch (Exception e) {
            System.out.println("!!!!!!createCategory Error: " + e.getMessage());
            e.printStackTrace();
        }
        return iiList;
    }
}

