/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo.common.navigation;

import java.io.Serializable;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import org.richfaces.demo.common.navigation.DemoDescriptor;
import org.richfaces.demo.common.navigation.GroupDescriptor;
import org.richfaces.demo.common.navigation.SampleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedBean
@SessionScoped
public class DemoNavigator
implements Serializable {
    private static final long serialVersionUID = 3970933260901989658L;
    private static final String DEMO_VIEW_PARAMETER = "demo";
    private static final String SAMPLE_VIEW_PARAMETER = "sample";
    private static final String SEPARATOR = "/";
    @ManagedProperty(value="#{navigationParser.groupsList}")
    private List<GroupDescriptor> groups;
    private DemoDescriptor currentDemo;
    private SampleDescriptor currentSample;
    private String sample;
    private String demo;

    @PostConstruct
    public void init() {
        this.currentDemo = null;
        this.currentSample = null;
    }

    public DemoDescriptor getCurrentDemo() {
        String id = this.getViewParameter(DEMO_VIEW_PARAMETER);
        if (this.currentDemo == null || !this.currentDemo.getId().equals(id)) {
            if (id != null) {
                this.currentDemo = this.findDemoById(id);
                this.currentSample = null;
            }
            if (this.currentDemo == null) {
                this.currentDemo = (DemoDescriptor)((GroupDescriptor)this.groups.get(0)).getDemos().get(0);
                this.currentSample = null;
            }
        }
        return this.currentDemo;
    }

    public SampleDescriptor getCurrentSample() {
        String id = this.getViewParameter(SAMPLE_VIEW_PARAMETER);
        if (this.currentSample == null || !this.currentSample.getId().equals(id)) {
            if (id != null) {
                this.currentSample = this.getCurrentDemo().getSampleById(id);
            }
            if (this.currentSample == null) {
                this.currentSample = (SampleDescriptor)this.getCurrentDemo().getSamples().get(0);
            }
        }
        return this.currentSample;
    }

    private String getViewParameter(String name) {
        FacesContext fc = FacesContext.getCurrentInstance();
        String param = (String)fc.getExternalContext().getRequestParameterMap().get(name);
        if (param != null && param.trim().length() > 0) {
            return param;
        }
        return null;
    }

    public DemoDescriptor findDemoById(String id) {
        for (GroupDescriptor group : this.groups) {
            for (DemoDescriptor demo : group.getDemos()) {
                if (!demo.getId().equals(id)) continue;
                return demo;
            }
        }
        return null;
    }

    public String getSampleURI() {
        DemoDescriptor currentDemo = this.getCurrentDemo();
        FacesContext context = FacesContext.getCurrentInstance();
        NavigationHandler handler = context.getApplication().getNavigationHandler();
        if (handler instanceof ConfigurableNavigationHandler) {
            ConfigurableNavigationHandler navigationHandler = (ConfigurableNavigationHandler)handler;
            NavigationCase navCase = navigationHandler.getNavigationCase(context, null, this.getCurrentDemo().getId() + SEPARATOR + this.getCurrentSample().getId());
            return navCase.getToViewId(context);
        }
        return null;
    }

    public List<GroupDescriptor> getGroups() {
        return this.groups;
    }

    public void setGroups(List<GroupDescriptor> groups) {
        this.groups = groups;
    }

    public String getSample() {
        return this.sample;
    }

    public void setSample(String sample) {
        this.sample = sample;
    }

    public String getDemo() {
        return this.demo;
    }

    public void setDemo(String demo) {
        this.demo = demo;
    }
}

