/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo;

import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.event.ValueChangeEvent;
import org.richfaces.component.Positioning;
import org.richfaces.event.CurrentDateChangeEvent;

@ManagedBean
@SessionScoped
public class CalendarBean {
    private Locale locale;
    private boolean popup = true;
    private String pattern = "d/M/yy HH:mm";
    private Date selectedDate;
    private boolean showApply = true;
    private boolean useCustomDayLabels;
    private String mode = "client";
    private Positioning jointPoint = Positioning.DEFAULT;
    private Positioning direction = Positioning.DEFAULT;
    private int horizontalOffset = 0;
    private int verticalOffset = 0;
    private Positioning[] positioningValues = Positioning.values();
    private TimeZone timeZone = TimeZone.getTimeZone("EST");

    public CalendarBean() {
        this.locale = Locale.US;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean isPopup() {
        return this.popup;
    }

    public void setPopup(boolean popup) {
        this.popup = popup;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void selectLocale(ValueChangeEvent event) {
        String tLocale = (String)event.getNewValue();
        if (tLocale != null) {
            String lang = tLocale.substring(0, 2);
            String country = tLocale.substring(3);
            this.locale = new Locale(lang, country, "");
        }
    }

    public boolean isUseCustomDayLabels() {
        return this.useCustomDayLabels;
    }

    public void setUseCustomDayLabels(boolean useCustomDayLabels) {
        this.useCustomDayLabels = useCustomDayLabels;
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(Date selectedDate) {
        this.selectedDate = selectedDate;
    }

    public boolean isShowApply() {
        return this.showApply;
    }

    public void setShowApply(boolean showApply) {
        this.showApply = showApply;
    }

    public void setJointPoint(Positioning jointPoint) {
        this.jointPoint = jointPoint;
    }

    public Positioning getJointPoint() {
        return this.jointPoint;
    }

    public void setDirection(Positioning direction) {
        this.direction = direction;
    }

    public Positioning getDirection() {
        return this.direction;
    }

    public void setHorizontalOffset(int horizontalOffset) {
        this.horizontalOffset = horizontalOffset;
    }

    public int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setVerticalOffset(int verticalOffset) {
        this.verticalOffset = verticalOffset;
    }

    public int getVerticalOffset() {
        return this.verticalOffset;
    }

    public void doValueChangeListener(ValueChangeEvent event) {
        System.out.println("doValueChangeListener: old value = " + event.getOldValue() + ", new value = " + event.getNewValue());
    }

    public void doCurrentDataChangeListener(CurrentDateChangeEvent event) {
        System.out.println("doCurrentDataChangeListener: " + event.getCurrentDateString());
    }

    public Positioning[] getPositioningValues() {
        return this.positioningValues;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }
}

