/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.util.dom;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cocoon.pipeline.component.sax.SAXConsumer;
import org.apache.cocoon.pipeline.util.dom.DOMStreamer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOMUtils {
    private static final DocumentBuilderFactory DBF = DocumentBuilderFactory.newInstance();

    private DOMUtils() {
    }

    public static Document toDOM(InputSource source, EntityResolver resolver) throws SAXException, IOException {
        try {
            DocumentBuilder documentBuilder = DBF.newDocumentBuilder();
            documentBuilder.setEntityResolver(resolver);
            return documentBuilder.parse(source);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("Error during XPointer evaluation while trying to load " + source, e);
        }
    }

    public static void stream(Node node, SAXConsumer xmlConsumer) throws SAXException {
        new DOMStreamer(xmlConsumer).stream(node);
    }

    static {
        DBF.setNamespaceAware(true);
        DBF.setXIncludeAware(false);
    }
}

