/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.handler.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.richfaces.application.ServiceTracker;
import org.richfaces.cdk.FileNameMapper;
import org.richfaces.cdk.strings.Constants;
import org.richfaces.resource.ResourceSkinUtils;

public class DynamicResourceWrapper
extends Resource {
    private static final String ECSS_EXTENSION = ".ecss";
    private Resource resource;

    public DynamicResourceWrapper(Resource resource) {
        this.resource = resource;
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    public String getContentType() {
        return this.resource.getContentType();
    }

    public void setContentType(String contentType) {
        this.resource.setContentType(contentType);
    }

    public String getLibraryName() {
        return this.resource.getLibraryName();
    }

    public void setLibraryName(String libraryName) {
        this.resource.setLibraryName(libraryName);
    }

    public String getResourceName() {
        return this.resource.getResourceName();
    }

    public void setResourceName(String resourceName) {
        this.resource.setResourceName(resourceName);
    }

    public Map<String, String> getResponseHeaders() {
        throw new UnsupportedOperationException();
    }

    private FileNameMapper getFileNameMapper() {
        return (FileNameMapper)ServiceTracker.getService(FileNameMapper.class);
    }

    public String getRequestPath() {
        String resourceExtension = this.getResourceExtension();
        String resourceName = this.getResourceName();
        if (resourceName.endsWith(ECSS_EXTENSION)) {
            resourceName = resourceName.substring(0, resourceName.length() - ECSS_EXTENSION.length());
        }
        if (resourceExtension != null && !resourceName.endsWith(resourceExtension)) {
            resourceName = resourceName + resourceExtension;
        }
        String resourcePath = Constants.SLASH_JOINER.join((Object)this.getLibraryName(), (Object)resourceName, new Object[0]);
        String filename = this.getFileNameMapper().createName(resourcePath);
        String filenameWithSkinPlaceholder = ResourceSkinUtils.prefixPathWithSkinPlaceholder((String)filename);
        return filenameWithSkinPlaceholder;
    }

    public URL getURL() {
        throw new UnsupportedOperationException();
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        throw new UnsupportedOperationException();
    }

    protected String getResourceExtension() {
        String[] split;
        String contentType = this.getContentType();
        if (contentType == null) {
            return null;
        }
        if ((contentType.startsWith("text/") || contentType.startsWith("image/")) && (split = contentType.split("/")).length == 2) {
            return '.' + split[1];
        }
        return null;
    }
}

