/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.faces;

import java.util.Collections;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.richfaces.application.DependencyInjectionServiceImpl;
import org.richfaces.application.DependencyInjector;
import org.richfaces.application.Module;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.ServicesFactory;
import org.richfaces.application.ServicesFactoryImpl;
import org.richfaces.application.configuration.ConfigurationService;
import org.richfaces.application.configuration.ConfigurationServiceImpl;
import org.richfaces.cdk.Faces;
import org.richfaces.cdk.FileNameMapper;
import org.richfaces.cdk.faces.FacesContextImpl;
import org.richfaces.cdk.skin.SkinFactoryImpl;
import org.richfaces.resource.external.ExternalResourceTracker;
import org.richfaces.resource.external.ExternalResourceTrackerWrapper;
import org.richfaces.resource.external.ExternalStaticResourceFactory;
import org.richfaces.resource.external.ExternalStaticResourceFactoryImpl;
import org.richfaces.skin.SkinFactory;

public class FacesImpl
implements Faces {
    private String webroot;
    private FileNameMapper fileNameMapper;
    private ResourceHandler resourceHandler;

    public FacesImpl(String webroot, FileNameMapper fileNameMapper, ResourceHandler resourceHandler) {
        this.webroot = webroot;
        this.fileNameMapper = fileNameMapper;
        this.resourceHandler = resourceHandler;
    }

    @Override
    public void start() {
        ServicesFactoryImpl serviceFactory = new ServicesFactoryImpl();
        Module module = new Module(){

            public void configure(ServicesFactory factory) {
                factory.setInstance(ConfigurationService.class, (Object)new ConfigurationServiceImpl());
                factory.setInstance(SkinFactory.class, (Object)new SkinFactoryImpl());
                factory.setInstance(FileNameMapper.class, (Object)FacesImpl.this.fileNameMapper);
                factory.setInstance(DependencyInjector.class, (Object)new DependencyInjectionServiceImpl());
                factory.setInstance(ResourceHandler.class, (Object)FacesImpl.this.resourceHandler);
                factory.setInstance(ExternalResourceTracker.class, (Object)new ExternalResourceTrackerWrapper());
                factory.setInstance(ExternalStaticResourceFactory.class, (Object)new ExternalStaticResourceFactoryImpl());
            }
        };
        ServiceTracker.setFactory((ServicesFactory)serviceFactory);
        this.startRequest();
        serviceFactory.init(Collections.singleton(module));
        this.stopRequest();
    }

    @Override
    public void stop() {
        ServiceTracker.release();
    }

    @Override
    public void setSkin(String skinName) {
        SkinFactoryImpl.setSkinName(skinName);
    }

    @Override
    public FacesContext startRequest() {
        FacesContextImpl facesContextImpl = new FacesContextImpl();
        facesContextImpl.getExternalContext().setWebRoot(this.webroot);
        assert (FacesContext.getCurrentInstance() != null);
        return facesContextImpl;
    }

    @Override
    public void stopRequest() {
        FacesContext.getCurrentInstance().release();
        assert (FacesContext.getCurrentInstance() == null);
    }
}

