/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.handler.impl;

import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.richfaces.cdk.resource.handler.impl.AbstractResourceHandler;
import org.richfaces.cdk.resource.handler.impl.DynamicResourceWrapper;
import org.richfaces.resource.ResourceFactory;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceRequestData;
import org.richfaces.util.Util;

public class DynamicResourceHandler
extends AbstractResourceHandler {
    private ResourceFactory resourceFactory;
    private ResourceHandler staticResourceHandler;

    public DynamicResourceHandler(ResourceHandler staticResourceHandler, ResourceFactory resourceFactory) {
        this.staticResourceHandler = staticResourceHandler;
        this.resourceFactory = resourceFactory;
    }

    @Override
    public Resource createResource(String resourceName, String libraryName, String contentType) {
        ResourceKey resourceKey = new ResourceKey(resourceName, libraryName);
        Resource result = this.resourceFactory.createResource(resourceName, libraryName, contentType);
        if (result != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            Object state = Util.saveResourceState((FacesContext)context, (Object)result);
            Resource newResource = this.resourceFactory.createResource(context, (ResourceRequestData)new ResourceRequestDataImpl(resourceKey, state));
            result = new DynamicResourceWrapper(newResource);
        } else {
            result = this.staticResourceHandler.createResource(resourceName, libraryName, contentType);
        }
        return result;
    }

    private static final class ResourceRequestDataImpl
    implements ResourceRequestData {
        private ResourceKey resourceKey;
        private Object resourceData;

        public ResourceRequestDataImpl(ResourceKey resourceKey, Object resourceData) {
            this.resourceKey = resourceKey;
            this.resourceData = resourceData;
        }

        public String getResourceName() {
            return this.resourceKey.getResourceName();
        }

        public String getLibraryName() {
            return this.resourceKey.getLibraryName();
        }

        public Object getData() {
            return this.resourceData;
        }

        public String getResourceKey() {
            return this.resourceKey.toString();
        }

        public String getVersion() {
            return null;
        }
    }
}

