/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.ordering;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.richfaces.cdk.ordering.IllegalPartialOrderingException;

public class PartialOrderToCompleteOrder<T> {
    private Set<T> allItems = Sets.newLinkedHashSet();
    private List<PartialOrdering> partialOrderings = new LinkedList<PartialOrdering>();
    private Map<T, Set<T>> dependencies = Maps.newLinkedHashMap();

    public void addPartialOrdering(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.checkCurrentPartialOrders(collection);
        this.allItems.addAll(collection);
        this.partialOrderings.add(new PartialOrdering(collection));
        this.registerDependencies(Lists.newLinkedList(collection));
    }

    public Set<T> getAllItems() {
        return this.allItems;
    }

    public CompleteOrdering getCompleteOrdering() {
        return new CompleteOrdering();
    }

    public Collection<T> getCompletelyOrderedItems() {
        return new CompleteOrdering().sortedCopy(this.allItems);
    }

    private void checkCurrentPartialOrders(Collection<T> collection) {
        for (PartialOrdering p : this.partialOrderings) {
            List filtered;
            if (p.isStrictlyOrdered(filtered = p.filter(collection))) continue;
            throw new IllegalPartialOrderingException("\ncollection: " + collection + "\n" + (Object)((Object)p));
        }
    }

    private void registerDependencies(Collection<T> collection) {
        List reversedOrder = Lists.reverse((List)Lists.newLinkedList(collection));
        LinkedHashSet newItemDependencies = Sets.newLinkedHashSet(collection);
        for (Object newItem : reversedOrder) {
            newItemDependencies.remove(newItem);
            this.registerDependenciesForItem(newItem, Sets.newLinkedHashSet((Iterable)newItemDependencies));
        }
    }

    private void registerDependenciesForItem(T item, Set<T> newItemDependencies) {
        if (!this.dependencies.containsKey(item)) {
            this.dependencies.put(item, Sets.newHashSet());
        }
        Set<T> itemDependences = this.dependencies.get(item);
        itemDependences.addAll(newItemDependencies);
    }

    private class PartialOrdering
    extends Ordering<T> {
        private LinkedList<T> order = Lists.newLinkedList();
        private HashSet<T> items = Sets.newHashSet();

        public PartialOrdering(Collection<T> collection) {
            this.order = Lists.newLinkedList(collection);
            this.items = Sets.newHashSet(collection);
        }

        public int compare(T left, T right) {
            if (!this.items.contains(left)) {
                throw new IllegalArgumentException("'" + left + "' is not part of this partial ordering");
            }
            if (!this.items.contains(right)) {
                throw new IllegalArgumentException("'" + right + "' is not part of this partial ordering");
            }
            return this.order.indexOf(left) - this.order.indexOf(right);
        }

        public List<T> filter(Collection<T> collection) {
            LinkedList list = new LinkedList(collection);
            list.retainAll(this.items);
            return list;
        }

        public String toString() {
            return "PartialOrder" + this.order;
        }
    }

    public class CompleteOrdering
    extends Ordering<T> {
        private Set<T> ordered = this.getCurrentOrder();
        private Predicate<T> IS_ORDERED = new Predicate<T>(){

            public boolean apply(T item) {
                return CompleteOrdering.this.ordered.contains(item);
            }
        };

        public int compare(T left, T right) {
            if (!this.ordered.contains(left) || !this.ordered.contains(right)) {
                throw new IllegalStateException();
            }
            if (left.equals(right)) {
                return 0;
            }
            for (Object item : this.ordered) {
                if (item.equals(left)) {
                    return -1;
                }
                if (!item.equals(right)) continue;
                return 1;
            }
            throw new IllegalStateException();
        }

        public <E extends T> List<E> sortedCopy(Iterable<E> iterable) {
            LinkedList originList = Lists.newLinkedList(iterable);
            Collection onlyOrdered = Collections2.filter((Collection)originList, this.IS_ORDERED);
            Collection onlyNotOrdered = Collections2.filter((Collection)originList, (Predicate)Predicates.not(this.IS_ORDERED));
            List itemsInOrder = super.sortedCopy((Iterable)onlyOrdered);
            itemsInOrder.addAll(onlyNotOrdered);
            return itemsInOrder;
        }

        private Set<T> getCurrentOrder() {
            LinkedHashSet result = Sets.newLinkedHashSet();
            DependencyResolver resolver = new DependencyResolver();
            for (int i = 0; i < PartialOrderToCompleteOrder.this.dependencies.size(); ++i) {
                List nodesWithoutDependencies = resolver.findNodesWithoutDependencies();
                result.addAll(nodesWithoutDependencies);
                resolver.removeNodes(nodesWithoutDependencies);
            }
            if (resolver.getSize() > 0) {
                throw new IllegalStateException();
            }
            return result;
        }

        private class DependencyResolver {
            private Map<T, Set<T>> deps = this.deepCopyOfDependencies();

            private DependencyResolver() {
            }

            private List<T> findNodesWithoutDependencies() {
                LinkedList list = Lists.newLinkedList();
                for (Map.Entry entry : this.deps.entrySet()) {
                    if (!entry.getValue().isEmpty()) continue;
                    list.add(entry.getKey());
                }
                return list;
            }

            private void removeNodes(List<T> nodes) {
                for (Set values : this.deps.values()) {
                    values.removeAll(nodes);
                }
                for (Set node : nodes) {
                    this.deps.remove(node);
                }
            }

            private Map<T, Set<T>> deepCopyOfDependencies() {
                LinkedHashMap result = Maps.newLinkedHashMap();
                for (Map.Entry entry : PartialOrderToCompleteOrder.this.dependencies.entrySet()) {
                    result.put(entry.getKey(), Sets.newHashSet((Iterable)((Iterable)entry.getValue())));
                }
                return result;
            }

            public int getSize() {
                return this.deps.size();
            }
        }
    }
}

