/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.writer.impl;

import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.maven.plugin.logging.Log;
import org.mozilla.javascript.ErrorReporter;
import org.richfaces.cdk.resource.writer.ResourceProcessor;
import org.richfaces.cdk.resource.writer.impl.MavenLogErrorReporter;

public class JavaScriptResourceProcessor
implements ResourceProcessor {
    private Charset charset;
    private Log log;

    public JavaScriptResourceProcessor(Charset charset, Log log) {
        this.charset = charset;
        this.log = log;
    }

    @Override
    public boolean isSupportedFile(String name) {
        return name.endsWith(".js");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String resourceName, InputSupplier<? extends InputStream> in, OutputSupplier<? extends OutputStream> out) throws IOException {
        InputStreamReader reader = null;
        OutputStreamWriter writer = null;
        try {
            reader = new InputStreamReader((InputStream)in.getInput(), this.charset);
            writer = new OutputStreamWriter((OutputStream)out.getOutput(), this.charset);
            MavenLogErrorReporter reporter = new MavenLogErrorReporter(resourceName);
            new JavaScriptCompressor((Reader)reader, (ErrorReporter)reporter).compress((Writer)writer, 0, true, true, false, false);
            if (reporter.hasErrors() && this.log.isErrorEnabled()) {
                this.log.error((CharSequence)reporter.getErrorsLog());
            }
            if (reporter.hasWarnings() && this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)reporter.getWarningsLog());
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(reader);
            Closeables.closeQuietly(writer);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)reader);
        Closeables.closeQuietly((Closeable)writer);
    }
}

