/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class CountingExecutorCompletionService<T>
extends ExecutorCompletionService<T> {
    private AtomicInteger tasksCounter = new AtomicInteger(0);

    public CountingExecutorCompletionService(Executor executor) {
        super(executor);
    }

    public CountingExecutorCompletionService(Executor executor, BlockingQueue<Future<T>> completionQueue) {
        super(executor, completionQueue);
    }

    @Override
    public Future<T> submit(Callable<T> task) {
        this.tasksCounter.getAndIncrement();
        return super.submit(task);
    }

    @Override
    public Future<T> submit(Runnable task, T result) {
        this.tasksCounter.getAndIncrement();
        return super.submit(task, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<T> take() throws InterruptedException {
        if (this.tasksCounter.get() == 0) {
            return null;
        }
        try {
            Future future = super.take();
            return future;
        }
        finally {
            this.tasksCounter.getAndDecrement();
        }
    }
}

