/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.writer.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.faces.application.Resource;
import org.apache.maven.plugin.logging.Log;
import org.richfaces.cdk.ResourceWriter;
import org.richfaces.cdk.resource.writer.ResourceProcessor;
import org.richfaces.cdk.resource.writer.impl.ThroughputResourceProcessor;
import org.richfaces.cdk.strings.Constants;

public class ResourceWriterImpl
implements ResourceWriter {
    private File resourceContentsDir;
    private File resourceMappingDir;
    private Map<String, String> processedResources = Maps.newConcurrentMap();
    private Iterable<ResourceProcessor> resourceProcessors;
    private Log log;
    private long currentTime;

    public ResourceWriterImpl(File resourceContentsDir, File resourceMappingDir, Iterable<ResourceProcessor> resourceProcessors, Log log) {
        this.resourceContentsDir = resourceContentsDir;
        this.resourceMappingDir = resourceMappingDir;
        this.resourceProcessors = Iterables.concat(resourceProcessors, Collections.singleton(ThroughputResourceProcessor.INSTANCE));
        this.log = log;
        resourceContentsDir.mkdirs();
        this.currentTime = System.currentTimeMillis();
    }

    private String getResourceQualifier(Resource resource) {
        return Constants.COLON_JOINER.join((Object)resource.getLibraryName(), (Object)resource.getResourceName(), new Object[0]);
    }

    private synchronized File createOutputFile(String path) throws IOException {
        File outFile = new File(this.resourceContentsDir, path);
        outFile.getParentFile().mkdirs();
        if (outFile.exists()) {
            if (outFile.lastModified() > this.currentTime) {
                this.log.warn((CharSequence)MessageFormat.format("File {0} already exists and will be overwritten", outFile.getPath()));
            }
            outFile.delete();
        }
        if (!outFile.createNewFile()) {
            this.log.warn((CharSequence)MessageFormat.format("Could not create {0} file", outFile.getPath()));
        }
        return outFile;
    }

    @Override
    public void writeResource(String skinName, Resource resource) throws IOException {
        String requestPath;
        String requestPathWithSkin = requestPath = resource.getRequestPath();
        if (requestPath.startsWith("%skin%/")) {
            requestPathWithSkin = Constants.SLASH_JOINER.join((Object)skinName, (Object)requestPath.substring("%skin%/".length()), new Object[0]);
        }
        ResourceProcessor matchingProcessor = (ResourceProcessor)Iterables.get((Iterable)Iterables.filter(this.resourceProcessors, (Predicate)new Predicate<ResourceProcessor>(){

            public boolean apply(ResourceProcessor input) {
                return input.isSupportedFile(requestPath);
            }
        }), (int)0);
        File outFile = this.createOutputFile(requestPathWithSkin);
        matchingProcessor.process(requestPathWithSkin, new ResourceInputStreamSupplier(resource), (OutputSupplier<? extends OutputStream>)Files.newOutputStreamSupplier((File)outFile));
        this.processedResources.put(this.getResourceQualifier(resource), requestPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeProcessedResourceMappings() throws IOException {
        FileOutputStream fos = null;
        try {
            File mappingsFile = new File(this.resourceMappingDir, "META-INF/richfaces/static-resource-mappings.properties");
            mappingsFile.delete();
            mappingsFile.getParentFile().mkdirs();
            mappingsFile.createNewFile();
            fos = new FileOutputStream(mappingsFile);
            Properties properties = new Properties();
            properties.putAll(this.processedResources);
            properties.store(fos, null);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static final class ResourceInputStreamSupplier
    implements InputSupplier<InputStream> {
        private Resource resource;

        public ResourceInputStreamSupplier(Resource resource) {
            this.resource = resource;
        }

        public InputStream getInput() throws IOException {
            return this.resource.getInputStream();
        }
    }
}

