/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.vfs.zip;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.richfaces.cdk.strings.Constants;
import org.richfaces.cdk.vfs.VirtualFile;
import org.richfaces.cdk.vfs.zip.ZipNode;

public class ZipVFSFile
implements VirtualFile {
    private ZipFile zipFile;
    private ZipNode zipNode;
    private String relativePath;

    public ZipVFSFile(ZipFile zipFile, ZipNode zipNode, String relativePath) {
        this.zipFile = zipFile;
        this.zipNode = zipNode;
        this.relativePath = relativePath;
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    public boolean isDirectory() {
        return this.zipNode.isDirectory();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ZipEntry entry = this.zipNode.getZipEntry();
        if (entry != null) {
            return this.zipFile.getInputStream(entry);
        }
        throw new IOException("Input stream isn't available!");
    }

    @Override
    public Collection<VirtualFile> getChildren() {
        Iterable<ZipNode> children = this.zipNode.listChildren();
        ArrayList result = Lists.newArrayList();
        for (ZipNode child : children) {
            result.add(new ZipVFSFile(this.zipFile, child, Constants.SLASH_JOINER.join((Object)this.getRelativePath(), (Object)child.getName(), new Object[0])));
        }
        return result;
    }

    @Override
    public VirtualFile getChild(String path) {
        return this.getChild(path, false);
    }

    @Override
    public VirtualFile getChild(String path, boolean chrooted) {
        Iterable split = Constants.SLASH_SPLITTER.split((CharSequence)path);
        ZipNode node = this.zipNode;
        for (String pathSeg : split) {
            if ((node = node.getChild(pathSeg)) != null) continue;
            return null;
        }
        String relativePath = null;
        if (!chrooted) {
            relativePath = Constants.SLASH_JOINER.join((Object)this.getRelativePath(), (Object)path, new Object[0]);
        }
        return new ZipVFSFile(this.zipFile, node, relativePath);
    }

    @Override
    public String getName() {
        return this.zipNode.getName();
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    protected ZipFile getZipFile() {
        return this.zipFile;
    }

    protected ZipNode getZipNode() {
        return this.zipNode;
    }
}

