/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.vfs.file;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.richfaces.cdk.strings.Constants;
import org.richfaces.cdk.vfs.VirtualFile;

public class FileVFSFile
implements VirtualFile {
    private File file;
    private String relativePath;

    public FileVFSFile(File file, String relativePath) {
        this.file = file;
        this.relativePath = relativePath;
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public Collection<VirtualFile> getChildren() {
        ArrayList result = Lists.newArrayList();
        String[] list = this.file.list();
        if (list != null) {
            for (String childName : list) {
                File child = new File(this.file, childName);
                result.add(new FileVFSFile(child, Constants.SLASH_JOINER.join((Object)this.relativePath, (Object)childName, new Object[0])));
            }
        }
        return result;
    }

    @Override
    public VirtualFile getChild(String path) {
        return this.getChild(path, false);
    }

    @Override
    public VirtualFile getChild(String path, boolean chrooted) {
        String pathSeg;
        Iterable split = Constants.SLASH_SPLITTER.split((CharSequence)path);
        File result = this.file;
        Iterator i$ = split.iterator();
        while (i$.hasNext() && (result = new File(result, pathSeg = (String)i$.next())).exists()) {
        }
        if (result.exists()) {
            return new FileVFSFile(result, chrooted ? null : Constants.SLASH_JOINER.join((Object)this.relativePath, (Object)result.getName(), new Object[0]));
        }
        return null;
    }

    protected File getFile() {
        return this.file;
    }
}

