/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.scan.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.reflections.Configuration;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;
import org.richfaces.cdk.resource.scan.ResourcesScanner;
import org.richfaces.cdk.resource.scan.impl.reflections.MarkerResourcesScanner;
import org.richfaces.cdk.resource.scan.impl.reflections.ReflectionsExt;
import org.richfaces.cdk.vfs.VFSRoot;
import org.richfaces.cdk.vfs.VFSType;
import org.richfaces.resource.DynamicResource;
import org.richfaces.resource.ResourceFactory;
import org.richfaces.resource.ResourceKey;

public class DynamicResourcesScanner
implements ResourcesScanner {
    private static final Function<Class<?>, ResourceKey> RESOURCE_LOCATOR_FUNCTION = new Function<Class<?>, ResourceKey>(){

        public ResourceKey apply(Class<?> from) {
            ResourceKey key = new ResourceKey(from.getName());
            return key;
        }
    };
    private static final Predicate<Class<?>> UNINSTANTIATABLE_CLASSES_PREDICATE = new Predicate<Class<?>>(){

        public boolean apply(Class<?> input) {
            return !input.isInterface() && !Modifier.isAbstract(input.getModifiers());
        }
    };
    private Collection<ResourceKey> resources = Sets.newHashSet();
    private Collection<VFSRoot> cpFiles;
    private ResourceFactory resourceFactory;

    public DynamicResourcesScanner(Collection<VFSRoot> cpFiles, ResourceFactory resourceFactory) {
        this.cpFiles = cpFiles;
        this.resourceFactory = resourceFactory;
    }

    @Override
    public void scan() throws IOException {
        HashSet urls = Sets.newHashSet();
        for (VFSRoot cpFile : this.cpFiles) {
            if (cpFile.getType() == VFSType.zip && cpFile.getChild("META-INF/faces-config.xml") == null) continue;
            URL url = cpFile.toURL();
            urls.add(url);
        }
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setUrls((Collection)urls);
        configurationBuilder.setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner(), new MarkerResourcesScanner()}).useParallelExecutor();
        ReflectionsExt refl = new ReflectionsExt((Configuration)configurationBuilder);
        Collection allClasses = Sets.newHashSet();
        for (Class annotatedClass : refl.getTypesAnnotatedWith(DynamicResource.class)) {
            allClasses.add(annotatedClass);
            allClasses.addAll(refl.getSubTypesOf(annotatedClass));
        }
        allClasses.addAll(refl.getMarkedClasses());
        allClasses = Collections2.filter((Collection)allClasses, UNINSTANTIATABLE_CLASSES_PREDICATE);
        this.resources.addAll(Collections2.transform((Collection)allClasses, RESOURCE_LOCATOR_FUNCTION));
        this.resources.addAll(this.resourceFactory.getMappedDynamicResourceKeys());
    }

    @Override
    public Collection<ResourceKey> getResources() {
        return this.resources;
    }
}

