/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.writer.impl;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.plugin.logging.Log;
import org.mozilla.javascript.ErrorReporter;
import org.richfaces.cdk.resource.writer.impl.CharResourceProcessor;
import org.richfaces.cdk.resource.writer.impl.MavenLogErrorReporter;

public class JavaScriptResourceProcessor
extends CharResourceProcessor {
    private Log log;

    public JavaScriptResourceProcessor(Log log) {
        this.log = log;
    }

    @Override
    public boolean isSupportedFile(String name) {
        return name.endsWith(".js");
    }

    @Override
    protected void doActualProcess(String resourceName, Reader in, Writer out) throws IOException {
        MavenLogErrorReporter reporter = new MavenLogErrorReporter(resourceName);
        new JavaScriptCompressor(in, (ErrorReporter)reporter).compress(out, 0, true, true, false, false);
        if (reporter.hasErrors()) {
            this.log.error((CharSequence)reporter.getErrorsLog());
        }
        if (reporter.hasWarnings()) {
            this.log.debug((CharSequence)reporter.getWarningsLog());
        }
    }
}

