/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.handler.impl;

import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.richfaces.cdk.resource.handler.impl.AbstractResourceHandler;
import org.richfaces.cdk.resource.handler.impl.DynamicResourceWrapper;
import org.richfaces.resource.ResourceFactory;
import org.richfaces.resource.ResourceFactoryImpl;
import org.richfaces.util.Util;

public class DynamicResourceHandler
extends AbstractResourceHandler {
    private ResourceFactory resourceFactory;
    private ResourceHandler staticResourceHandler;

    public DynamicResourceHandler(ResourceHandler staticResourceHandler) {
        this.staticResourceHandler = staticResourceHandler;
        this.resourceFactory = new ResourceFactoryImpl(staticResourceHandler);
    }

    private void setupResourceState(Resource source, Resource target) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Object state = Util.saveResourceState((FacesContext)facesContext, (Object)source);
        if (state != null) {
            Util.restoreResourceState((FacesContext)facesContext, (Object)target, (Object)state);
        }
    }

    @Override
    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Resource result = this.resourceFactory.createResource(resourceName, libraryName, contentType);
        if (result != null) {
            Resource newResource = this.resourceFactory.createResource(resourceName, libraryName, contentType);
            this.setupResourceState(newResource, result);
            result = new DynamicResourceWrapper(result);
        } else {
            result = this.staticResourceHandler.createResource(resourceName, libraryName, contentType);
        }
        return result;
    }
}

