/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.Logger;

public class JavaLogger
implements Logger {
    public static final String CDK_LOG = "org.richfaces.cdk";
    private static final String CLASS_NAME = JavaLogger.class.getName();
    private int errorCount = 0;
    private Throwable firstError;
    private java.util.logging.Logger jdkLogger = java.util.logging.Logger.getLogger("org.richfaces.cdk");

    private void fillCallerData(String fqn, LogRecord record) {
        int idx;
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        for (int i = 0; i < stackTrace.length && !fqn.equals(stackTrace[i].getClassName()); ++i) {
        }
        for (idx = i + 1; idx < stackTrace.length && fqn.equals(stackTrace[idx].getClassName()); ++idx) {
        }
        if (idx < stackTrace.length) {
            record.setSourceMethodName(stackTrace[idx].getMethodName());
            record.setSourceClassName(stackTrace[idx].getClassName());
        }
    }

    private LogRecord createRecord(Level level, CharSequence message, Throwable thrown) {
        LogRecord record = new LogRecord(level, message != null ? message.toString() : null);
        record.setLoggerName(this.jdkLogger.getName());
        record.setThrown(thrown);
        this.fillCallerData(CLASS_NAME, record);
        return record;
    }

    @Override
    public void debug(CharSequence content) {
        if (this.jdkLogger.isLoggable(Level.FINE)) {
            this.jdkLogger.log(this.createRecord(Level.FINE, content, null));
        }
    }

    @Override
    public void debug(CharSequence content, Throwable error) {
        if (this.jdkLogger.isLoggable(Level.FINE)) {
            this.jdkLogger.log(this.createRecord(Level.FINE, content, error));
        }
    }

    @Override
    public void debug(Throwable error) {
        if (this.jdkLogger.isLoggable(Level.FINE)) {
            this.jdkLogger.log(this.createRecord(Level.FINE, "", error));
        }
    }

    @Override
    public void error(CharSequence content) {
        ++this.errorCount;
        this.firstError = new CdkException(content.toString());
        if (this.jdkLogger.isLoggable(Level.SEVERE)) {
            this.jdkLogger.log(this.createRecord(Level.SEVERE, content, null));
        }
    }

    @Override
    public void error(CharSequence content, Throwable error) {
        ++this.errorCount;
        this.firstError = error;
        if (this.jdkLogger.isLoggable(Level.SEVERE)) {
            this.jdkLogger.log(this.createRecord(Level.SEVERE, content, error));
        }
    }

    @Override
    public void error(Throwable error) {
        ++this.errorCount;
        this.firstError = error;
        if (this.jdkLogger.isLoggable(Level.SEVERE)) {
            this.jdkLogger.log(this.createRecord(Level.SEVERE, "", error));
        }
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void info(CharSequence content) {
        if (this.jdkLogger.isLoggable(Level.INFO)) {
            this.jdkLogger.log(this.createRecord(Level.INFO, content, null));
        }
    }

    @Override
    public void info(CharSequence content, Throwable error) {
        if (this.jdkLogger.isLoggable(Level.INFO)) {
            this.jdkLogger.log(this.createRecord(Level.INFO, content, error));
        }
    }

    @Override
    public void info(Throwable error) {
        if (this.jdkLogger.isLoggable(Level.INFO)) {
            this.jdkLogger.log(this.createRecord(Level.INFO, "", error));
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.jdkLogger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.jdkLogger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.jdkLogger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.jdkLogger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(CharSequence content) {
        if (this.jdkLogger.isLoggable(Level.WARNING)) {
            this.jdkLogger.log(this.createRecord(Level.WARNING, content, null));
        }
    }

    @Override
    public void warn(CharSequence content, Throwable error) {
        if (this.jdkLogger.isLoggable(Level.WARNING)) {
            this.jdkLogger.log(this.createRecord(Level.WARNING, content, error));
        }
    }

    @Override
    public void warn(Throwable error) {
        if (this.jdkLogger.isLoggable(Level.WARNING)) {
            this.jdkLogger.log(this.createRecord(Level.WARNING, "", error));
        }
    }

    @Override
    public Throwable getFirstError() {
        return this.firstError;
    }
}

