/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.attributes;

import java.util.Collection;
import java.util.HashSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.richfaces.cdk.attributes.ContainerType;
import org.richfaces.cdk.attributes.KeyedType;

public class Attribute
implements KeyedType {
    private String name;
    private boolean required;
    private String defaultValue;
    private String componentAttributeName;
    private Kind kind = Kind.GENERIC;

    public Attribute() {
    }

    public Attribute(String name) {
        this.name = name;
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @XmlElement
    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @XmlElement(name="default-value")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @XmlElement
    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    @XmlElement(name="component-attribute-name")
    public String getComponentAttributeName() {
        return this.componentAttributeName != null ? this.componentAttributeName : this.name;
    }

    public void setComponentAttributeName(String componentAttributeName) {
        this.componentAttributeName = componentAttributeName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return super.toString() + " " + this.getName();
    }

    @XmlRootElement(name="attributes")
    @XmlType(name="AttributesType")
    public static final class Type
    implements ContainerType<Attribute> {
        private Collection<Attribute> children = new HashSet<Attribute>();

        @Override
        @XmlElement(name="attribute")
        public Collection<Attribute> getChildren() {
            return this.children;
        }

        @Override
        public void setChildren(Collection<Attribute> values) {
            this.children = values;
        }
    }

    public static enum Kind {
        GENERIC,
        BOOLEAN,
        URI;

    }
}

