/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.yum;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.rhq.core.domain.content.PackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetailsKey;
import org.rhq.enterprise.server.plugins.yum.RepoReader;
import org.rhq.enterprise.server.plugins.yum.Repodata;

public class Repo {
    private Repodata repodata;

    public Repo(RepoReader reader) {
        this.repodata = new Repodata(reader);
    }

    public void connect() throws Exception {
        this.repodata.refresh();
    }

    public void disconnect() {
        this.repodata.clear();
    }

    public String getPackageMetadataString(String pkgname) throws Exception {
        return Repodata.toString(this.getPackageMetadata(pkgname));
    }

    public Element getPackageMetadata(String pkgname) throws Exception {
        Element primary = this.repodata.getMetadata(Repodata.Meta.primary);
        for (Element p : primary.getChildren("package", Repodata.yumns)) {
            if (!p.getChildText("name", Repodata.yumns).equals(pkgname)) continue;
            return p;
        }
        return null;
    }

    public List<ContentProviderPackageDetails> getPackageDetails() throws Exception {
        ArrayList<ContentProviderPackageDetails> list = new ArrayList<ContentProviderPackageDetails>();
        Element primary = this.repodata.getMetadata(Repodata.Meta.primary);
        for (Element p : primary.getChildren("package", Repodata.yumns)) {
            list.add(this.getDetails(p));
        }
        return list;
    }

    public PackageDetails getPackageDetails(String pkgname) throws Exception {
        return this.getDetails(this.getPackageMetadata(pkgname));
    }

    public InputStream openPackageStream(String pkgname) throws Exception {
        String location = this.packageLocation(pkgname);
        return this.repodata.getReader().openStream(location);
    }

    public String packageLocation(String pkgname) throws Exception {
        Element p = this.getPackageMetadata(pkgname);
        return p.getChild("location", Repodata.yumns).getAttributeValue("href");
    }

    private String encodeVersion(Element p) {
        Element version = p.getChild("version", Repodata.yumns);
        StringBuilder sb = new StringBuilder();
        sb.append(version.getAttributeValue("epoch"));
        sb.append('.');
        sb.append(version.getAttributeValue("ver"));
        sb.append('.');
        sb.append(version.getAttributeValue("rel"));
        return sb.toString();
    }

    private String filename(Element p) {
        String[] parts = this.location(p).split("[/\\\\]");
        return parts[parts.length - 1];
    }

    private Long filedate(Element p) {
        String date = p.getChild("time", Repodata.yumns).getAttributeValue("file");
        return Long.parseLong(date);
    }

    private String location(Element p) {
        return p.getChild("location", Repodata.yumns).getAttributeValue("href");
    }

    private ContentProviderPackageDetails getDetails(Element p) throws Exception {
        String name = p.getChildText("name", Repodata.yumns);
        String version = this.encodeVersion(p);
        String arch = p.getChildText("arch", Repodata.yumns);
        ContentProviderPackageDetailsKey key = new ContentProviderPackageDetailsKey(name, version, "rpm", arch, "Linux", "Platforms");
        ContentProviderPackageDetails pkg = new ContentProviderPackageDetails(key);
        String filename = this.filename(p);
        pkg.setDisplayName(filename);
        pkg.setShortDescription(p.getChildText("summary", Repodata.yumns));
        pkg.setLongDescription(p.getChildText("description", Repodata.yumns));
        pkg.setFileName(filename);
        pkg.setFileSize(Long.valueOf(Long.parseLong(p.getChild("size", Repodata.yumns).getAttributeValue("package"))));
        pkg.setFileCreatedDate(this.filedate(p));
        pkg.setLicenseName(p.getChild("format", Repodata.yumns).getChildText("license", Repodata.rpmns));
        pkg.setSHA256(p.getChildText("checksum", Repodata.yumns));
        pkg.setLocation(this.location(p));
        pkg.setMetadata(this.gzip(p));
        return pkg;
    }

    private byte[] gzip(Element p) throws IOException {
        XMLOutputter printer = new XMLOutputter();
        ByteArrayOutputStream zipped = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(zipped);
        printer.output(p, (OutputStream)gzip);
        gzip.flush();
        gzip.close();
        return zipped.toByteArray();
    }
}

