/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.yum;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.PackageSource;
import org.rhq.enterprise.server.plugin.pc.content.PackageSyncReport;
import org.rhq.enterprise.server.plugins.yum.DiskReader;
import org.rhq.enterprise.server.plugins.yum.HttpReader;
import org.rhq.enterprise.server.plugins.yum.Repo;
import org.rhq.enterprise.server.plugins.yum.RepoReader;
import org.rhq.enterprise.server.plugins.yum.Summary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoProvider
implements ContentProvider,
PackageSource {
    private RepoReader reader;
    private Repo repo;
    private final Log log = LogFactory.getLog(RepoProvider.class);

    public void initialize(Configuration configuration) throws Exception {
        String location = configuration.getSimpleValue("location", null);
        if (location == null) {
            throw new IllegalArgumentException("Missing required 'location' property");
        }
        location = this.trim(location);
        this.log.info((Object)("Initialized with location: " + location));
        if (location.startsWith("http://")) {
            this.reader = new HttpReader(location);
            return;
        }
        if (location.startsWith("file://")) {
            location = location.substring(7);
            this.reader = new DiskReader(location);
            return;
        }
        this.reader = new DiskReader(location);
    }

    public void shutdown() {
        this.log.debug((Object)"shutdown");
    }

    public InputStream getInputStream(String location) throws Exception {
        this.log.debug((Object)("opening: " + location));
        return this.reader.openStream(location);
    }

    public void synchronizePackages(String repoName, PackageSyncReport report, Collection<ContentProviderPackageDetails> existingPackages) throws Exception {
        Summary summary = new Summary(this.reader);
        this.log.info((Object)("synchronizing with repo: " + this.reader + " started"));
        try {
            summary.markStarted();
            this.repo = new Repo(this.reader);
            this.repo.connect();
            ArrayList<ContentProviderPackageDetails> deletedPackages = new ArrayList<ContentProviderPackageDetails>();
            deletedPackages.addAll(existingPackages);
            for (ContentProviderPackageDetails p : this.repo.getPackageDetails()) {
                this.log.debug((Object)("Processing package at (" + p.getLocation()));
                deletedPackages.remove(p);
                if (existingPackages.contains(p)) continue;
                this.log.debug((Object)("New package at (" + p.getLocation() + ") detected"));
                report.addNewPackage(p);
                ++summary.added;
            }
            for (ContentProviderPackageDetails p : deletedPackages) {
                this.log.debug((Object)("Package at (" + p.getDisplayName() + ") marked as deleted"));
                report.addDeletePackage(p);
                ++summary.deleted;
            }
        }
        catch (Exception e) {
            summary.errors.add(e.toString());
            throw e;
        }
        finally {
            this.repo.disconnect();
            summary.markEnded();
            report.setSummary(summary.toString());
            this.log.info((Object)("synchronizing with repo: " + this.reader + " finished\n" + summary));
        }
    }

    public void testConnection() throws Exception {
        this.reader.validate();
    }

    private String trim(String path) {
        path = path.trim();
        while (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

