/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.yum;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.rhq.enterprise.server.plugins.yum.RepoReader;

public class DiskReader
implements RepoReader {
    private final String basepath;

    public DiskReader(String basepath) {
        this.basepath = basepath;
    }

    public void validate() throws Exception {
        File file = new File(this.basepath);
        if (file.exists() || file.canRead() || file.isDirectory()) {
            return;
        }
        throw new Exception("Path: '" + this.basepath + "' not found, not a directory or permission denied");
    }

    public InputStream openStream(String path) throws IOException {
        FileInputStream in = new FileInputStream(this.basepath + "/" + path);
        if (path.endsWith(".gz")) {
            return new GZIPInputStream(in);
        }
        return in;
    }

    public String toString() {
        return "basepath: " + this.basepath;
    }
}

