/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.filetemplate;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bundle.filetemplate.recipe.RecipeContext;
import org.rhq.bundle.filetemplate.recipe.RecipeParser;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.DeploymentProperties;
import org.rhq.enterprise.server.bundle.BundleDistributionInfo;
import org.rhq.enterprise.server.bundle.RecipeParseResults;
import org.rhq.enterprise.server.plugin.pc.ControlFacet;
import org.rhq.enterprise.server.plugin.pc.ControlResults;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginFacet;

public class BundleServerPluginComponent
implements ServerPluginComponent,
BundleServerPluginFacet,
ControlFacet {
    private final Log log = LogFactory.getLog(BundleServerPluginComponent.class);
    private ServerPluginContext context;

    public void initialize(ServerPluginContext context) throws Exception {
        this.context = context;
        this.log.debug((Object)("The filetemplate bundle plugin has been initialized!!! : " + this));
    }

    public void start() {
        this.log.debug((Object)("The filetemplate bundle plugin has started!!! : " + this));
    }

    public void stop() {
        this.log.debug((Object)("The filetemplate bundle plugin has stopped!!! : " + this));
    }

    public void shutdown() {
        this.log.debug((Object)("The filetemplate bundle plugin has been shut down!!! : " + this));
    }

    public RecipeParseResults parseRecipe(String recipe) throws Exception {
        RecipeParser parser = new RecipeParser();
        RecipeContext recipeContext = new RecipeContext(recipe);
        parser.parseRecipe(recipeContext);
        DeploymentProperties bundleMetadata = recipeContext.getDeploymentProperties();
        HashSet bundleFileNames = new HashSet();
        Map deployFiles = recipeContext.getDeployFiles();
        bundleFileNames.addAll(deployFiles.keySet());
        Set scriptFiles = recipeContext.getScriptFiles();
        bundleFileNames.addAll(scriptFiles);
        Set files = recipeContext.getFiles().keySet();
        bundleFileNames.addAll(files);
        ConfigurationDefinition configDef = null;
        if (recipeContext.getReplacementVariables() != null) {
            configDef = new ConfigurationDefinition("replacementVariables", null);
            for (String replacementVar : recipeContext.getReplacementVariables()) {
                PropertyDefinitionSimple prop = new PropertyDefinitionSimple(replacementVar, "Needed by bundle recipe.", false, PropertySimpleType.STRING);
                prop.setDisplayName(replacementVar);
                configDef.put((PropertyDefinition)prop);
            }
        }
        RecipeParseResults results = new RecipeParseResults(bundleMetadata, configDef, bundleFileNames);
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BundleDistributionInfo processBundleDistributionFile(File distributionFile) throws Exception {
        if (null == distributionFile) {
            throw new IllegalArgumentException("distributionFile == null");
        }
        BundleDistributionInfo info = null;
        String recipe = null;
        RecipeParseResults recipeParseResults = null;
        Map<String, File> bundleFiles = null;
        RecipeVisitor recipeVisitor = new RecipeVisitor(this, "deploy.txt");
        ZipUtil.walkZipFile((File)distributionFile, (ZipUtil.ZipEntryVisitor)recipeVisitor);
        recipe = recipeVisitor.getRecipe();
        recipeParseResults = recipeVisitor.getResults();
        if (null == recipeParseResults) {
            if (distributionFile.length() >= 50000L) throw new IllegalArgumentException("Not a File Template Bundle");
            try {
                byte[] content = StreamUtil.slurp((InputStream)new FileInputStream(distributionFile));
                recipe = new String(content);
                content = null;
                recipeParseResults = this.parseRecipe(recipe);
                return new BundleDistributionInfo(recipe, recipeParseResults, bundleFiles);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Not a File Template Bundle");
            }
        } else {
            BundleFileVisitor bundleFileVisitor = new BundleFileVisitor(recipeParseResults.getBundleMetadata().getBundleName(), recipeParseResults.getBundleFileNames());
            ZipUtil.walkZipFile((File)distributionFile, (ZipUtil.ZipEntryVisitor)bundleFileVisitor);
            bundleFiles = bundleFileVisitor.getBundleFiles();
        }
        return new BundleDistributionInfo(recipe, recipeParseResults, bundleFiles);
    }

    public ControlResults invoke(String name, Configuration parameters) {
        ControlResults controlResults = new ControlResults();
        if (name.equals("testControl")) {
            System.out.println("Invoked 'testControl': " + this);
        } else {
            controlResults.setError("Unknown operation name: " + name);
        }
        return controlResults;
    }

    public String toString() {
        if (this.context == null) {
            return "<no context>";
        }
        StringBuilder str = new StringBuilder();
        str.append("plugin-key=").append(this.context.getPluginEnvironment().getPluginKey()).append(",");
        str.append("plugin-url=").append(this.context.getPluginEnvironment().getPluginUrl()).append(",");
        str.append("plugin-config=[").append(this.getPluginConfigurationString()).append(']');
        return str.toString();
    }

    private String getPluginConfigurationString() {
        String results = "";
        Configuration config = this.context.getPluginConfiguration();
        for (PropertySimple prop : config.getSimpleProperties().values()) {
            if (results.length() > 0) {
                results = results + ", ";
            }
            results = results + prop.getName() + "=" + prop.getStringValue();
        }
        return results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BundleFileVisitor
    implements ZipUtil.ZipEntryVisitor {
        private Set<String> bundleFileNames;
        private Map<String, File> bundleFiles;
        private File tmpDir;

        public BundleFileVisitor(String bundleName, Set<String> bundleFileNames) throws IOException {
            this.bundleFileNames = bundleFileNames;
            this.bundleFiles = new HashMap<String, File>(bundleFileNames.size());
            this.tmpDir = FileUtil.createTempDirectory((String)"file-template-bundle", (String)".dir", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean visit(ZipEntry entry, ZipInputStream stream) throws Exception {
            if (this.bundleFileNames.contains(entry.getName())) {
                File bundleFile = new File(this.tmpDir, entry.getName());
                bundleFile.getParentFile().mkdirs();
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(bundleFile);
                    StreamUtil.copy((InputStream)stream, (OutputStream)fos, (boolean)false);
                }
                finally {
                    if (null != fos) {
                        try {
                            fos.close();
                        }
                        catch (Exception e) {}
                    }
                }
                this.bundleFiles.put(entry.getName(), bundleFile);
            }
            return true;
        }

        public Map<String, File> getBundleFiles() {
            return this.bundleFiles;
        }
    }

    private static class RecipeVisitor
    implements ZipUtil.ZipEntryVisitor {
        private RecipeParseResults results = null;
        private String recipeName = null;
        private BundleServerPluginFacet facet = null;
        private String recipe = null;

        public RecipeVisitor(BundleServerPluginFacet facet, String recipeName) {
            this.facet = facet;
            this.recipeName = recipeName;
        }

        public boolean visit(ZipEntry entry, ZipInputStream stream) throws Exception {
            if (this.recipeName.equalsIgnoreCase(entry.getName())) {
                ByteArrayOutputStream out = new ByteArrayOutputStream((int)entry.getSize());
                StreamUtil.copy((InputStream)stream, (OutputStream)out, (boolean)false);
                this.recipe = new String(out.toByteArray());
                out = null;
                try {
                    this.results = this.facet.parseRecipe(this.recipe);
                }
                catch (Throwable t) {
                    this.results = null;
                }
                return false;
            }
            return true;
        }

        public RecipeParseResults getResults() {
            return this.results;
        }

        public String getRecipe() {
            return this.recipe;
        }
    }
}

