/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.filetemplate;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bundle.filetemplate.recipe.RecipeContext;
import org.rhq.bundle.filetemplate.recipe.RecipeParser;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.enterprise.server.bundle.RecipeParseResults;
import org.rhq.enterprise.server.plugin.pc.ControlFacet;
import org.rhq.enterprise.server.plugin.pc.ControlResults;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginFacet;

public class BundleServerPluginComponent
implements ServerPluginComponent,
BundleServerPluginFacet,
ControlFacet {
    private final Log log = LogFactory.getLog(BundleServerPluginComponent.class);
    private ServerPluginContext context;

    public void initialize(ServerPluginContext context) throws Exception {
        this.context = context;
        this.log.debug((Object)("The filetemplate bundle plugin has been initialized!!! : " + this));
    }

    public void start() {
        this.log.debug((Object)("The filetemplate bundle plugin has started!!! : " + this));
    }

    public void stop() {
        this.log.debug((Object)("The filetemplate bundle plugin has stopped!!! : " + this));
    }

    public void shutdown() {
        this.log.debug((Object)("The filetemplate bundle plugin has been shut down!!! : " + this));
    }

    public RecipeParseResults parseRecipe(String recipe) throws Exception {
        RecipeParser parser = new RecipeParser();
        RecipeContext recipeContext = new RecipeContext(recipe);
        parser.parseRecipe(recipeContext);
        HashSet bundleFileNames = new HashSet();
        Map deployFiles = recipeContext.getDeployFiles();
        bundleFileNames.addAll(deployFiles.keySet());
        Set scriptFiles = recipeContext.getScriptFiles();
        bundleFileNames.addAll(scriptFiles);
        ConfigurationDefinition configDef = null;
        if (recipeContext.getReplacementVariables() != null) {
            configDef = new ConfigurationDefinition("replacementVariables", null);
            for (String replacementVar : recipeContext.getReplacementVariables()) {
                PropertyDefinitionSimple prop = new PropertyDefinitionSimple(replacementVar, null, false, PropertySimpleType.STRING);
                configDef.put((PropertyDefinition)prop);
            }
        }
        RecipeParseResults results = new RecipeParseResults(configDef, bundleFileNames);
        return results;
    }

    public ControlResults invoke(String name, Configuration parameters) {
        ControlResults controlResults = new ControlResults();
        if (name.equals("testControl")) {
            System.out.println("Invoked 'testControl': " + this);
        } else {
            controlResults.setError("Unknown operation name: " + name);
        }
        return controlResults;
    }

    public String toString() {
        if (this.context == null) {
            return "<no context>";
        }
        StringBuilder str = new StringBuilder();
        str.append("plugin-key=").append(this.context.getPluginEnvironment().getPluginKey()).append(",");
        str.append("plugin-url=").append(this.context.getPluginEnvironment().getPluginUrl()).append(",");
        str.append("plugin-config=[").append(this.getPluginConfigurationString()).append(']');
        return str.toString();
    }

    private String getPluginConfigurationString() {
        String results = "";
        Configuration config = this.context.getPluginConfiguration();
        for (PropertySimple prop : config.getSimpleProperties().values()) {
            if (results.length() > 0) {
                results = results + ", ";
            }
            results = results + prop.getName() + "=" + prop.getStringValue();
        }
        return results;
    }
}

