/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.StorageStateListener;

public class StorageSession
implements Host.StateListener {
    private Session wrappedSession;
    private List<StorageStateListener> listeners = new ArrayList<StorageStateListener>();

    public StorageSession(Session wrappedSession) {
        this.wrappedSession = wrappedSession;
        this.wrappedSession.getCluster().register((Host.StateListener)this);
    }

    public void addStorageStateListener(StorageStateListener listener) {
        this.listeners.add(listener);
    }

    public ResultSet execute(String query) {
        try {
            return this.wrappedSession.execute(query);
        }
        catch (NoHostAvailableException e) {
            this.fireClusterDownEvent(e);
            throw e;
        }
    }

    public ResultSet execute(Query query) {
        try {
            return this.wrappedSession.execute(query);
        }
        catch (NoHostAvailableException e) {
            this.fireClusterDownEvent(e);
            throw e;
        }
    }

    public StorageResultSetFuture executeAsync(String query) {
        ResultSetFuture future = this.wrappedSession.executeAsync(query);
        return new StorageResultSetFuture(future, this);
    }

    public StorageResultSetFuture executeAsync(Query query) {
        ResultSetFuture future = this.wrappedSession.executeAsync(query);
        return new StorageResultSetFuture(future, this);
    }

    public PreparedStatement prepare(String query) {
        return this.wrappedSession.prepare(query);
    }

    public void shutdown() {
        this.wrappedSession.shutdown();
    }

    public boolean shutdown(long timeout, TimeUnit unit) {
        return this.wrappedSession.shutdown(timeout, unit);
    }

    public Cluster getCluster() {
        return this.wrappedSession.getCluster();
    }

    public void onAdd(Host host) {
        for (StorageStateListener listener : this.listeners) {
            listener.onStorageNodeUp(host.getAddress());
        }
    }

    public void onUp(Host host) {
        for (StorageStateListener listener : this.listeners) {
            listener.onStorageNodeUp(host.getAddress());
        }
    }

    public void onDown(Host host) {
        for (StorageStateListener listener : this.listeners) {
            listener.onStorageNodeDown(host.getAddress());
        }
    }

    public void onRemove(Host host) {
        for (StorageStateListener listener : this.listeners) {
            listener.onStorageNodeRemoved(host.getAddress());
        }
    }

    void fireClusterDownEvent(NoHostAvailableException e) {
        for (StorageStateListener listener : this.listeners) {
            listener.onStorageClusterDown(e);
        }
    }
}

