/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.rhq.server.metrics.StorageSession;

public class StorageResultSetFuture
implements ListenableFuture<ResultSet> {
    private ResultSetFuture wrapperFuture;
    private StorageSession session;

    public StorageResultSetFuture(ResultSetFuture resultSetFuture, StorageSession session) {
        this.wrapperFuture = resultSetFuture;
        this.session = session;
    }

    public void addListener(Runnable listener, Executor executor) {
        this.wrapperFuture.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.wrapperFuture.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.wrapperFuture.isCancelled();
    }

    public boolean isDone() {
        return this.wrapperFuture.isDone();
    }

    public ResultSet get() {
        try {
            return this.wrapperFuture.getUninterruptibly();
        }
        catch (NoHostAvailableException e) {
            this.session.fireClusterDownEvent(e);
            throw e;
        }
    }

    public ResultSet get(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return this.wrapperFuture.getUninterruptibly(timeout, unit);
        }
        catch (NoHostAvailableException e) {
            this.session.fireClusterDownEvent(e);
            throw e;
        }
    }
}

