/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.ReadablePeriod;
import org.rhq.server.metrics.domain.MetricsTable;

public class MetricsConfiguration {
    private ReadablePeriod rawRetention = Days.days((int)7);
    private ReadablePeriod oneHourRetention = Days.days((int)14);
    private ReadablePeriod sixHourRetention = Days.days((int)31);
    private ReadablePeriod twentyFourHourRetention = Days.days((int)365);
    private int rawTTL = MetricsTable.RAW.getTTL();
    private int oneHourTTL = MetricsTable.ONE_HOUR.getTTL();
    private int sixHourTTL = MetricsTable.SIX_HOUR.getTTL();
    private int twentyFourHourTTL = MetricsTable.TWENTY_FOUR_HOUR.getTTL();
    private Duration rawTimeSliceDuration = Duration.standardHours((long)1L);
    private Duration oneHourTimeSliceDuration = Duration.standardHours((long)6L);
    private Duration sixHourTimeSliceDuration = Duration.standardHours((long)24L);

    public int getRawTTL() {
        return this.rawTTL;
    }

    public void setRawTTL(int rawTTL) {
        this.rawTTL = rawTTL;
    }

    public int getOneHourTTL() {
        return this.oneHourTTL;
    }

    public void setOneHourTTL(int oneHourTTL) {
        this.oneHourTTL = oneHourTTL;
    }

    public int getSixHourTTL() {
        return this.sixHourTTL;
    }

    public void setSixHourTTL(int sixHourTTL) {
        this.sixHourTTL = sixHourTTL;
    }

    public int getTwentyFourHourTTL() {
        return this.twentyFourHourTTL;
    }

    public void setTwentyFourHourTTL(int twentyFourHourTTL) {
        this.twentyFourHourTTL = twentyFourHourTTL;
    }

    public ReadablePeriod getRawRetention() {
        return this.rawRetention;
    }

    public void setRawRetention(Duration retention) {
        this.rawRetention = this.rawRetention;
    }

    public ReadablePeriod getOneHourRetention() {
        return this.oneHourRetention;
    }

    public void setOneHourRetention(ReadablePeriod retention) {
        this.oneHourRetention = retention;
    }

    public ReadablePeriod getSixHourRetention() {
        return this.sixHourRetention;
    }

    public void setSixHourRetention(ReadablePeriod retention) {
        this.sixHourRetention = retention;
    }

    public ReadablePeriod getTwentyFourHourRetention() {
        return this.twentyFourHourRetention;
    }

    public void setTwentyFourHourRetention(ReadablePeriod retention) {
        this.twentyFourHourRetention = retention;
    }

    public Duration getRawTimeSliceDuration() {
        return this.rawTimeSliceDuration;
    }

    public void setRawTimeSliceDuration(Duration rawTimeSliceDuration) {
        this.rawTimeSliceDuration = rawTimeSliceDuration;
    }

    public Duration getOneHourTimeSliceDuration() {
        return this.oneHourTimeSliceDuration;
    }

    public void setOneHourTimeSliceDuration(Duration oneHourTimeSliceDuration) {
        this.oneHourTimeSliceDuration = oneHourTimeSliceDuration;
    }

    public Duration getSixHourTimeSliceDuration() {
        return this.sixHourTimeSliceDuration;
    }

    public void setSixHourTimeSliceDuration(Duration sixHourTimeSliceDuration) {
        this.sixHourTimeSliceDuration = sixHourTimeSliceDuration;
    }

    public Duration getTimeSliceDuration(MetricsTable table) {
        if (MetricsTable.RAW.equals((Object)table)) {
            return this.getRawTimeSliceDuration();
        }
        if (MetricsTable.ONE_HOUR.equals((Object)table)) {
            return this.getOneHourTimeSliceDuration();
        }
        if (MetricsTable.SIX_HOUR.equals((Object)table)) {
            return this.getSixHourTimeSliceDuration();
        }
        throw new IllegalArgumentException("Time slice duration for " + table.getTableName() + " table is not supported");
    }
}

