/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.domain;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.rhq.server.metrics.CQLException;
import org.rhq.server.metrics.StorageSession;
import org.rhq.server.metrics.domain.ResultSetMapper;

public class ListPagedResult<T>
implements Iterable<T> {
    private final List<Integer> scheduleIds;
    private final long startTime;
    private final long endTime;
    private final ResultSetMapper<T> mapper;
    private final StorageSession session;
    private final PreparedStatement preparedStatement;

    public ListPagedResult(PreparedStatement preparedStatement, List<Integer> scheduleIds, long startTime, long endTime, ResultSetMapper<T> mapper, StorageSession session) {
        this.preparedStatement = preparedStatement;
        this.scheduleIds = new LinkedList<Integer>(scheduleIds);
        this.startTime = startTime;
        this.endTime = endTime;
        this.mapper = mapper;
        this.session = session;
    }

    private ResultSet retrieveNextResultSet(ResultSet existingResultSet, List<Integer> ids) {
        try {
            while ((existingResultSet == null || existingResultSet.isExhausted()) && ids.size() != 0) {
                BoundStatement boundStatement = this.preparedStatement.bind(new Object[]{ids.remove(0), new Date(this.startTime), new Date(this.endTime)});
                existingResultSet = this.session.execute((Query)boundStatement);
            }
        }
        catch (NoHostAvailableException e) {
            throw new CQLException(e);
        }
        return existingResultSet;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final List<Integer> ids;
            private ResultSet resultSet;
            private T lastRetrievedItem;
            {
                this.ids = new LinkedList<Integer>(ListPagedResult.this.scheduleIds);
                this.resultSet = ListPagedResult.this.retrieveNextResultSet(null, this.ids);
                this.lastRetrievedItem = null;
            }

            @Override
            public boolean hasNext() {
                this.resultSet = ListPagedResult.this.retrieveNextResultSet(this.resultSet, this.ids);
                return this.resultSet != null && !this.resultSet.isExhausted();
            }

            @Override
            public T next() {
                this.lastRetrievedItem = ListPagedResult.this.mapper.mapOne(this.resultSet);
                return this.lastRetrievedItem;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

