/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.rhq.server.metrics.AbortedException;

class TaskTracker {
    private volatile int remainingTasks;
    private volatile boolean schedulingFinished;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private CountDownLatch allTasksFinished = new CountDownLatch(1);
    private volatile boolean aborted;
    private String errorMessage;

    TaskTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask() {
        try {
            this.lock.writeLock().lock();
            ++this.remainingTasks;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getRemainingTasks() {
        return this.remainingTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedSchedulingTasks() {
        try {
            this.lock.writeLock().lock();
            this.schedulingFinished = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedTask() {
        try {
            this.lock.writeLock().lock();
            --this.remainingTasks;
            if (this.schedulingFinished && this.remainingTasks == 0) {
                this.allTasksFinished.countDown();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTasksToFinish() throws InterruptedException, AbortedException {
        try {
            this.lock.readLock().lock();
            if (this.aborted) {
                throw new AbortedException(this.errorMessage);
            }
            if (this.remainingTasks == 0) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.allTasksFinished.await();
        try {
            this.lock.readLock().lock();
            if (this.aborted) {
                throw new AbortedException(this.errorMessage);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(String msg) {
        try {
            this.lock.writeLock().lock();
            this.errorMessage = msg;
            this.aborted = true;
            this.allTasksFinished.countDown();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

