/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ResultSet;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.aggregation.IndexAggregatesPair;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.AggregateType;
import org.rhq.server.metrics.domain.MetricsTable;
import org.rhq.server.metrics.domain.NumericMetric;

class PersistFunctions {
    private MetricsDAO dao;
    private DateTimeService dateTimeService;
    private AsyncFunction<IndexAggregatesPair, List<ResultSet>> persist1HourMetricsAndUpdateCache;
    private AsyncFunction<IndexAggregatesPair, List<ResultSet>> persist1HourMetrics;
    private AsyncFunction<IndexAggregatesPair, List<ResultSet>> persist6HourMetricsAndUpdateCache;
    private AsyncFunction<IndexAggregatesPair, List<ResultSet>> persist6HourMetrics;
    private AsyncFunction<IndexAggregatesPair, List<ResultSet>> persist24HourMetrics;

    public PersistFunctions(MetricsDAO dao, DateTimeService dateTimeService) {
        this.dao = dao;
        this.dateTimeService = dateTimeService;
        this.initFunctions();
    }

    private void initFunctions() {
        this.persist1HourMetrics = new AsyncFunction<IndexAggregatesPair, List<ResultSet>>(){

            public ListenableFuture<List<ResultSet>> apply(IndexAggregatesPair pair) {
                ArrayList futures = new ArrayList(pair.metrics.size() * 3);
                for (AggregateNumericMetric metric : pair.metrics) {
                    futures.addAll(PersistFunctions.this.persist1HourMetric(metric));
                }
                return Futures.allAsList(futures);
            }
        };
        this.persist1HourMetricsAndUpdateCache = new AsyncFunction<IndexAggregatesPair, List<ResultSet>>(){

            public ListenableFuture<List<ResultSet>> apply(IndexAggregatesPair pair) {
                ArrayList<StorageResultSetFuture> futures = new ArrayList<StorageResultSetFuture>(pair.metrics.size() * 5);
                long start6HourTimeSlice = PersistFunctions.this.dateTimeService.get6HourTimeSlice(pair.cacheIndexEntry.getCollectionTimeSlice()).getMillis();
                for (AggregateNumericMetric metric : pair.metrics) {
                    futures.addAll(PersistFunctions.this.persist1HourMetric(metric));
                    futures.add(PersistFunctions.this.dao.updateMetricsCache(MetricsTable.ONE_HOUR, start6HourTimeSlice, pair.cacheIndexEntry.getStartScheduleId(), metric.getScheduleId(), metric.getTimestamp(), metric.toMap()));
                    futures.add(PersistFunctions.this.dao.updateCacheIndex(MetricsTable.ONE_HOUR, pair.cacheIndexEntry.getDay(), 0, start6HourTimeSlice, pair.cacheIndexEntry.getStartScheduleId(), start6HourTimeSlice, pair.cacheIndexEntry.getScheduleIds()));
                }
                return Futures.allAsList(futures);
            }
        };
        this.persist6HourMetrics = new AsyncFunction<IndexAggregatesPair, List<ResultSet>>(){

            public ListenableFuture<List<ResultSet>> apply(IndexAggregatesPair pair) {
                ArrayList futures = new ArrayList(pair.metrics.size() * 3);
                for (AggregateNumericMetric metric : pair.metrics) {
                    futures.addAll(PersistFunctions.this.persist6HourMetric(metric));
                }
                return Futures.allAsList(futures);
            }
        };
        this.persist6HourMetricsAndUpdateCache = new AsyncFunction<IndexAggregatesPair, List<ResultSet>>(){

            public ListenableFuture<List<ResultSet>> apply(IndexAggregatesPair pair) {
                ArrayList<StorageResultSetFuture> futures = new ArrayList<StorageResultSetFuture>(pair.metrics.size() * 5);
                long start24HourTimeSlice = PersistFunctions.this.dateTimeService.get24HourTimeSlice(pair.cacheIndexEntry.getCollectionTimeSlice()).getMillis();
                for (AggregateNumericMetric metric : pair.metrics) {
                    futures.addAll(PersistFunctions.this.persist6HourMetric(metric));
                    futures.add(PersistFunctions.this.dao.updateMetricsCache(MetricsTable.SIX_HOUR, start24HourTimeSlice, pair.cacheIndexEntry.getStartScheduleId(), metric.getScheduleId(), metric.getTimestamp(), metric.toMap()));
                    futures.add(PersistFunctions.this.dao.updateCacheIndex(MetricsTable.SIX_HOUR, start24HourTimeSlice, 0, start24HourTimeSlice, pair.cacheIndexEntry.getStartScheduleId(), start24HourTimeSlice, pair.cacheIndexEntry.getScheduleIds()));
                }
                return Futures.allAsList(futures);
            }
        };
        this.persist24HourMetrics = new AsyncFunction<IndexAggregatesPair, List<ResultSet>>(){

            public ListenableFuture<List<ResultSet>> apply(IndexAggregatesPair pair) {
                ArrayList<StorageResultSetFuture> futures = new ArrayList<StorageResultSetFuture>(pair.metrics.size() * 3);
                for (NumericMetric numericMetric : pair.metrics) {
                    futures.add(PersistFunctions.this.dao.insertTwentyFourHourDataAsync(numericMetric.getScheduleId(), numericMetric.getTimestamp(), AggregateType.MAX, numericMetric.getMax()));
                    futures.add(PersistFunctions.this.dao.insertTwentyFourHourDataAsync(numericMetric.getScheduleId(), numericMetric.getTimestamp(), AggregateType.MIN, numericMetric.getMin()));
                    futures.add(PersistFunctions.this.dao.insertTwentyFourHourDataAsync(numericMetric.getScheduleId(), numericMetric.getTimestamp(), AggregateType.AVG, numericMetric.getAvg()));
                }
                return Futures.allAsList(futures);
            }
        };
    }

    private List<StorageResultSetFuture> persist1HourMetric(AggregateNumericMetric metric) {
        return ImmutableList.of((Object)this.dao.insertOneHourDataAsync(metric.getScheduleId(), metric.getTimestamp(), AggregateType.MAX, metric.getMax()), (Object)this.dao.insertOneHourDataAsync(metric.getScheduleId(), metric.getTimestamp(), AggregateType.MIN, metric.getMin()), (Object)this.dao.insertOneHourDataAsync(metric.getScheduleId(), metric.getTimestamp(), AggregateType.AVG, metric.getAvg()));
    }

    private List<StorageResultSetFuture> persist6HourMetric(AggregateNumericMetric metric) {
        return ImmutableList.of((Object)this.dao.insertSixHourDataAsync(metric.getScheduleId(), metric.getTimestamp(), AggregateType.MAX, metric.getMax()), (Object)this.dao.insertSixHourDataAsync(metric.getScheduleId(), metric.getTimestamp(), AggregateType.MIN, metric.getMin()), (Object)this.dao.insertSixHourDataAsync(metric.getScheduleId(), metric.getTimestamp(), AggregateType.AVG, metric.getAvg()));
    }

    public AsyncFunction<IndexAggregatesPair, List<ResultSet>> persist1HourMetrics() {
        return this.persist1HourMetrics;
    }

    public AsyncFunction<IndexAggregatesPair, List<ResultSet>> persist1HourMetricsAndUpdateCache() {
        return this.persist1HourMetricsAndUpdateCache;
    }

    public AsyncFunction<IndexAggregatesPair, List<ResultSet>> persist6HourMetrics() {
        return this.persist6HourMetrics;
    }

    public AsyncFunction<IndexAggregatesPair, List<ResultSet>> persist6HourMetricsAndUpdateCache() {
        return this.persist6HourMetricsAndUpdateCache;
    }

    public AsyncFunction<IndexAggregatesPair, List<ResultSet>> persist24HourMetrics() {
        return this.persist24HourMetrics;
    }
}

