/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.aggregation.CacheIndexQueryException;
import org.rhq.server.metrics.domain.CacheIndexEntry;
import org.rhq.server.metrics.domain.CacheIndexEntryMapper;
import org.rhq.server.metrics.domain.MetricsTable;

public class IndexEntriesLoader {
    private DateTime currentTimeSlice;
    private DateTime currentDay;
    private MetricsDAO dao;
    private CacheIndexEntryMapper mapper;

    public IndexEntriesLoader(DateTime currentTimeSlice, DateTime currentDay, MetricsDAO dao) {
        this.currentTimeSlice = currentTimeSlice;
        this.currentDay = currentDay;
        this.dao = dao;
        this.mapper = new CacheIndexEntryMapper();
    }

    public List<CacheIndexEntry> loadPastIndexEntries(DateTime startDay) {
        try {
            DateTime day = startDay;
            DateTime timeSlice = day.plusHours(this.currentTimeSlice.getHourOfDay());
            ArrayList<CacheIndexEntry> indexEntries = new ArrayList<CacheIndexEntry>();
            StorageResultSetFuture future = this.dao.findPastCacheIndexEntriesBeforeToday(MetricsTable.RAW, day.getMillis(), 0, timeSlice.getMillis());
            this.addResultSet(indexEntries, future);
            day = day.plusDays(1);
            while (day.isBefore((ReadableInstant)this.currentDay)) {
                future = this.dao.findCacheIndexEntriesByDay(MetricsTable.RAW, day.getMillis(), 0);
                this.addResultSet(indexEntries, future);
                day = day.plusDays(1);
            }
            future = this.dao.findPastCacheIndexEntriesFromToday(MetricsTable.RAW, this.currentDay.getMillis(), 0, this.currentTimeSlice.getMillis());
            this.addResultSet(indexEntries, future);
            return indexEntries;
        }
        catch (Exception e) {
            throw new CacheIndexQueryException("Failed to load cache index entries prior to current time slice " + this.currentTimeSlice, e);
        }
    }

    public List<CacheIndexEntry> loadCurrentCacheIndexEntries(int pageSize, MetricsTable table) {
        try {
            ArrayList<CacheIndexEntry> indexEntries = new ArrayList<CacheIndexEntry>();
            StorageResultSetFuture future = this.dao.findCurrentCacheIndexEntries(table, this.currentDay.getMillis(), 0, this.currentTimeSlice.getMillis());
            ResultSet resultSet = future.get();
            if (resultSet.isExhausted()) {
                return indexEntries;
            }
            this.addResultSet(indexEntries, future);
            while (indexEntries.size() % pageSize == 0) {
                int startScheduleId = ((CacheIndexEntry)indexEntries.get(indexEntries.size() - 1)).getStartScheduleId();
                future = this.dao.findCurrentCacheIndexEntries(table, this.currentDay.getMillis(), 0, this.currentTimeSlice.getMillis(), startScheduleId);
                resultSet = future.get();
                if (resultSet.isExhausted()) break;
                this.addResultSet(indexEntries, resultSet);
            }
            return indexEntries;
        }
        catch (Exception e) {
            throw new CacheIndexQueryException("Failed to load cache index entries for current time slice " + this.currentTimeSlice, e);
        }
    }

    private void addResultSet(List<CacheIndexEntry> indexEntries, StorageResultSetFuture future) {
        this.addResultSet(indexEntries, future.get());
    }

    private void addResultSet(List<CacheIndexEntry> indexEntries, ResultSet resultSet) {
        for (Row row : resultSet) {
            indexEntries.add(this.mapper.map(row));
        }
    }
}

