/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import com.datastax.driver.core.ResultSet;
import com.google.common.base.Function;
import java.util.List;
import org.rhq.server.metrics.ArithmeticMeanCalculator;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.AggregateNumericMetricMapper;

public class ComputeAggregate
implements Function<ResultSet, AggregateNumericMetric> {
    private AggregateNumericMetricMapper mapper;
    private long timestamp;

    public ComputeAggregate(long timestamp) {
        this.timestamp = timestamp;
        this.mapper = new AggregateNumericMetricMapper();
    }

    public AggregateNumericMetric apply(ResultSet resultSet) {
        double min;
        List<AggregateNumericMetric> metrics = this.mapper.mapAll(resultSet);
        double max = min = Double.NaN;
        int count = 0;
        ArithmeticMeanCalculator mean = new ArithmeticMeanCalculator();
        for (AggregateNumericMetric metric : metrics) {
            if (count == 0) {
                min = metric.getMin();
                max = metric.getMax();
            }
            if (metric.getMin() < min) {
                min = metric.getMin();
            } else if (metric.getMax() > max) {
                max = metric.getMax();
            }
            mean.add(metric.getAvg());
            ++count;
        }
        return new AggregateNumericMetric(0, mean.getArithmeticMean(), min, max, this.timestamp);
    }
}

