/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.File;
import org.apache.commons.cli.Options;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;

public class Remove
extends ControlCommand {
    private Options options = new Options().addOption(null, "storage", false, "Remove RHQ storage node service").addOption(null, "server", false, "Remove RHQ server service").addOption(null, "agent", false, "Remove RHQ agent service");

    @Override
    public String getName() {
        return "remove";
    }

    @Override
    public String getDescription() {
        return "Removes RHQ services on Windows.";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    protected void exec(org.apache.commons.cli.CommandLine commandLine) {
        try {
            if (commandLine.getOptions().length == 0) {
                if (this.isAgentInstalled()) {
                    this.removeAgentService();
                }
                if (this.isServerInstalled()) {
                    this.removeServerService();
                }
                if (this.isStorageInstalled()) {
                    this.removeStorageService();
                }
            } else {
                if (commandLine.hasOption("agent")) {
                    if (this.isAgentInstalled()) {
                        this.removeAgentService();
                    } else {
                        this.log.warn((Object)"It appears that the agent is not installed. The --agent option will be ignored.");
                    }
                }
                if (commandLine.hasOption("server")) {
                    if (this.isServerInstalled()) {
                        this.removeServerService();
                    } else {
                        this.log.warn((Object)"It appears that the server is not installed. The --server option will be ignored.");
                    }
                }
                if (commandLine.hasOption("storage")) {
                    if (this.isStorageInstalled()) {
                        this.removeStorageService();
                    } else {
                        this.log.warn((Object)"It appears that the storage node is not installed. The --storage option will be ignored.");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RHQControlException("Failed to stop services", e);
        }
    }

    private void removeStorageService() throws Exception {
        this.log.debug((Object)"Stopping RHQ storage node");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.getBinDir());
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        if (this.isWindows()) {
            CommandLine commandLine = this.getCommandLine("rhq-storage", "remove");
            try {
                executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to remove storage service", (Throwable)e);
            }
        } else {
            String pid = this.getStoragePid();
            if (pid != null) {
                System.out.println("Stopping RHQ storage node...");
                System.out.println("RHQ storage node (pid=" + pid + ") is stopping...");
                CommandLine commandLine = new CommandLine("kill").addArgument(pid);
                executor.execute(commandLine);
                System.out.println("RHQ storage node has stopped");
            }
        }
    }

    private void removeServerService() throws Exception {
        this.log.debug((Object)"Stopping RHQ server");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.getBinDir());
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        if (this.isWindows()) {
            try {
                CommandLine commandLine = this.getCommandLine("rhq-server", "remove");
                executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to remove server service", (Throwable)e);
            }
        } else {
            String pid = this.getServerPid();
            if (pid != null) {
                CommandLine commandLine = this.getCommandLine("rhq-server", "stop");
                executor.execute(commandLine);
            }
        }
    }

    private void removeAgentService() throws Exception {
        this.log.debug((Object)"Stopping RHQ agent");
        File agentBinDir = new File(this.getAgentBasedir(), "bin");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(agentBinDir);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        if (this.isWindows()) {
            try {
                CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "remove");
                executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to remove agent service", (Throwable)e);
            }
        } else {
            String pid = this.getAgentPid();
            if (pid != null) {
                CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "stop");
                executor.execute(commandLine);
            }
        }
    }
}

