/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.server.control.RHQControlException;

public abstract class ControlCommand {
    public static final String SERVER_OPTION = "server";
    public static final String STORAGE_OPTION = "storage";
    public static final String AGENT_OPTION = "agent";
    public static final String RHQ_STORAGE_BASEDIR_PROP = "rhq.storage.basedir";
    public static final String RHQ_AGENT_BASEDIR_PROP = "rhq.agent.basedir";
    protected static final String STORAGE_BASEDIR_NAME = "rhq-storage";
    protected static final String AGENT_BASEDIR_NAME = "rhq-agent";
    private final File defaultStorageBasedir;
    private final File defaultAgentBasedir;
    protected final Log log = LogFactory.getLog((String)this.getClass().getName());
    private File basedir = new File(System.getProperty("rhq.server.basedir"));
    private File binDir = new File(this.basedir, "bin");
    private PropertiesConfiguration rhqctlConfig;

    public ControlCommand() {
        File rhqctlPropertiesFile = this.getRhqCtlProperties();
        try {
            this.rhqctlConfig = new PropertiesConfiguration(rhqctlPropertiesFile);
        }
        catch (ConfigurationException e) {
            throw new RHQControlException("Failed to load configuration", e);
        }
        this.defaultStorageBasedir = new File(this.getBaseDir(), STORAGE_BASEDIR_NAME);
        this.defaultAgentBasedir = new File(this.getBaseDir().getParent(), AGENT_BASEDIR_NAME);
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract Options getOptions();

    protected abstract void exec(org.apache.commons.cli.CommandLine var1);

    public void exec(String[] args) {
        Options options = this.getOptions();
        try {
            PosixParser parser = new PosixParser();
            org.apache.commons.cli.CommandLine cmdLine = parser.parse(options, args);
            this.exec(cmdLine);
            this.rhqctlConfig.save();
        }
        catch (ParseException e) {
            this.printUsage();
        }
        catch (ConfigurationException e) {
            throw new RHQControlException("Failed to update " + this.getRhqCtlProperties(), e);
        }
    }

    public void printUsage() {
        Options options = this.getOptions();
        HelpFormatter helpFormatter = new HelpFormatter();
        String header = "\n" + this.getDescription() + "\n\n";
        String syntax = options.getOptions().isEmpty() ? "rhqctl " + this.getName() : "rhqctl " + this.getName() + " [options]";
        helpFormatter.setNewLine("\n");
        helpFormatter.printHelp(syntax, header, options, null);
    }

    protected List<Integer> toIntList(String s) {
        String[] args = s.split(",");
        ArrayList<Integer> list = new ArrayList<Integer>(args.length);
        for (String arg : args) {
            list.add(Integer.parseInt(arg));
        }
        return list;
    }

    protected File getBaseDir() {
        return this.basedir;
    }

    protected File getBinDir() {
        return this.binDir;
    }

    protected File getLogDir() {
        return new File(this.getBaseDir(), "logs");
    }

    protected File getStorageBasedir() {
        return new File(this.getProperty(RHQ_STORAGE_BASEDIR_PROP, this.defaultStorageBasedir.getAbsolutePath()));
    }

    protected File getAgentBasedir() {
        return new File(this.getProperty(RHQ_AGENT_BASEDIR_PROP, this.defaultAgentBasedir.getAbsolutePath()));
    }

    protected boolean isServerInstalled() {
        return this.isServerInstalled(this.getBaseDir());
    }

    protected boolean isServerInstalled(File baseDir) {
        File markerFile = new File(baseDir, "jbossas/standalone/data/rhq.installed");
        return markerFile.exists();
    }

    protected boolean isAgentInstalled() {
        return this.getAgentBasedir().exists();
    }

    protected boolean isStorageInstalled() {
        return this.getStorageBasedir().exists();
    }

    protected File getStoragePidFile() {
        File storageBasedir = this.getStorageBasedir();
        File storageBinDir = new File(storageBasedir, "bin");
        File pidFile = new File(storageBinDir, "cassandra.pid");
        return pidFile;
    }

    protected String getStoragePid() throws IOException {
        File pidFile = this.getStoragePidFile();
        if (pidFile.exists()) {
            return StreamUtil.slurp((Reader)new FileReader(pidFile));
        }
        return null;
    }

    protected String getServerPid() throws IOException {
        File pidFile = new File(this.binDir, "rhq-server.pid");
        if (pidFile.exists()) {
            return StreamUtil.slurp((Reader)new FileReader(pidFile));
        }
        return null;
    }

    protected String getAgentPid() throws IOException {
        File agentBinDir = new File(this.getAgentBasedir(), "bin");
        File pidFile = new File(agentBinDir, "rhq-agent.pid");
        if (pidFile.exists()) {
            return StreamUtil.slurp((Reader)new FileReader(pidFile));
        }
        return null;
    }

    protected boolean hasProperty(String key) {
        return this.rhqctlConfig.containsKey(key);
    }

    protected String getProperty(String key) {
        return this.rhqctlConfig.getString(key);
    }

    private String getProperty(String key, String defaultValue) {
        return this.rhqctlConfig.getString(key, defaultValue);
    }

    protected void putProperty(String key, String value) {
        this.rhqctlConfig.setProperty(key, (Object)value);
    }

    protected File getRhqCtlProperties() {
        String sysprop = System.getProperty("rhqctl.properties-file");
        if (sysprop == null) {
            throw new RuntimeException("The required system property [rhqctl.properties-file] is not defined.");
        }
        File file = new File(sysprop);
        if (!file.isFile()) {
            throw new RHQControlException("rhqctl.properties-file has as its values [" + file + "] which is not " + "a file.");
        }
        return file;
    }

    protected CommandLine getCommandLine(String scriptName, String ... args) {
        return this.getCommandLine(true, scriptName, args);
    }

    protected CommandLine getCommandLine(boolean addShExt, String scriptName, String ... args) {
        CommandLine result;
        if (this.isWindows()) {
            result = new CommandLine("cmd.exe");
            result.addArgument("/C");
            result.addArgument(scriptName + ".bat");
        } else {
            result = new CommandLine("./" + (addShExt ? scriptName + ".sh" : scriptName));
        }
        for (String arg : args) {
            result.addArgument(arg);
        }
        return result;
    }

    protected String getScript(String scriptName) {
        if (this.isWindows()) {
            return scriptName + ".bat";
        }
        return "./" + scriptName + ".sh";
    }

    protected boolean isWindows() {
        String operatingSystem = System.getProperty("os.name").toLowerCase(Locale.US);
        return operatingSystem.contains("windows");
    }

    protected boolean isPortInUse(String host, int port) {
        boolean inUse;
        try {
            Socket testSocket = new Socket(host, port);
            try {
                testSocket.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            inUse = true;
        }
        catch (Exception expected) {
            inUse = false;
        }
        return inUse;
    }

    protected void waitForProcessToStop(String pid) throws Exception {
        if (this.isWindows() || pid == null) {
            Thread.sleep(10000L);
        } else {
            int tries;
            for (tries = 5; tries > 0; --tries) {
                this.log.debug((Object)".");
                if (!this.isUnixPidRunning(pid)) break;
                Thread.sleep(2000L);
            }
            if (tries == 0) {
                throw new RHQControlException("Process [" + pid + "] did not finish yet. Terminate it manually and retry.");
            }
        }
    }

    protected void killPid(String pid) throws IOException {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.getBinDir());
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine commandLine = new CommandLine("kill").addArgument(pid);
        executor.execute(commandLine);
    }

    protected boolean isUnixPidRunning(String pid) {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.getBinDir());
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine commandLine = new CommandLine("/bin/kill").addArgument("-0").addArgument(pid);
        try {
            int code = executor.execute(commandLine);
            if (code != 0) {
                return false;
            }
        }
        catch (ExecuteException ee) {
            if (ee.getExitValue() == 1) {
                return false;
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Checking for running process failed: " + e.getMessage()));
        }
        return true;
    }

    protected boolean isStorageRunning() throws IOException {
        String pid = this.getStoragePid();
        if (pid == null) {
            return false;
        }
        if (pid != null && !this.isUnixPidRunning(pid)) {
            File pidFile = this.getStoragePidFile();
            if (!pidFile.delete()) {
                throw new RHQControlException("Could not delete storage pidfile " + pidFile.getAbsolutePath());
            }
            return false;
        }
        return true;
    }
}

