/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.File;
import org.apache.commons.cli.Options;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.rhq.server.control.RHQControlException;
import org.rhq.server.control.command.AbstractInstall;

public class Stop
extends AbstractInstall {
    private Options options = new Options().addOption(null, "storage", false, "Stop RHQ storage node").addOption(null, "server", false, "Stop RHQ server").addOption(null, "agent", false, "Stop RHQ agent");

    @Override
    public String getName() {
        return "stop";
    }

    @Override
    public String getDescription() {
        return "Stops RHQ services";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    protected void exec(org.apache.commons.cli.CommandLine commandLine) {
        try {
            if (commandLine.getOptions().length == 0) {
                if (this.isAgentInstalled()) {
                    this.stopAgent();
                }
                if (this.isServerInstalled()) {
                    this.stopRHQServer();
                }
                if (this.isStorageInstalled()) {
                    this.stopStorage();
                }
            } else {
                if (commandLine.hasOption("agent")) {
                    if (this.isAgentInstalled()) {
                        this.stopAgent();
                    } else {
                        this.log.warn((Object)"It appears that the agent is not installed. The --agent option will be ignored.");
                    }
                }
                if (commandLine.hasOption("server")) {
                    if (this.isServerInstalled()) {
                        this.stopRHQServer();
                    } else {
                        this.log.warn((Object)"It appears that the server is not installed. The --server option will be ignored.");
                    }
                }
                if (commandLine.hasOption("storage")) {
                    if (this.isStorageInstalled()) {
                        this.stopStorage();
                    } else {
                        this.log.warn((Object)"It appears that the storage node is not installed. The --storage option will be ignored.");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RHQControlException("Failed to stop services", e);
        }
    }

    private void stopStorage() throws Exception {
        this.log.debug((Object)"Stopping RHQ storage node");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.getBinDir());
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        if (this.isWindows()) {
            CommandLine commandLine = this.getCommandLine("rhq-storage", "stop");
            try {
                executor.execute(commandLine);
                System.out.println("RHQ storage node has stopped");
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to stop storage service", (Throwable)e);
            }
        } else {
            String pid = this.getStoragePid();
            if (pid != null) {
                System.out.println("Stopping RHQ storage node...");
                System.out.println("RHQ storage node (pid=" + pid + ") is stopping...");
                CommandLine commandLine = new CommandLine("kill").addArgument(pid);
                executor.execute(commandLine);
                this.waitForProcessToStop(pid);
                System.out.println("RHQ storage node has stopped");
            }
        }
    }

    private void stopRHQServer() throws Exception {
        this.log.debug((Object)"Stopping RHQ server");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.getBinDir());
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine commandLine = this.getCommandLine("rhq-server", "stop");
        if (this.isWindows()) {
            try {
                executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to stop server service", (Throwable)e);
            }
        } else {
            String pid = this.getServerPid();
            if (pid != null) {
                executor.execute(commandLine);
            }
        }
    }

    private void stopAgent() throws Exception {
        this.log.debug((Object)"Stopping RHQ agent");
        File agentBinDir = new File(this.getAgentBasedir(), "bin");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(agentBinDir);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "stop");
        if (this.isWindows()) {
            try {
                executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to stop agent service", (Throwable)e);
            }
        } else {
            String pid = this.getAgentPid();
            if (pid != null) {
                executor.execute(commandLine);
            }
        }
    }
}

