/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.apache.commons.cli.Options;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;

public class Start
extends ControlCommand {
    private Options options = new Options().addOption(null, "storage", false, "Start RHQ storage node").addOption(null, "server", false, "Start RHQ server").addOption(null, "agent", false, "Start RHQ agent");

    @Override
    public String getName() {
        return "start";
    }

    @Override
    public String getDescription() {
        return "Starts RHQ services.";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    protected void exec(org.apache.commons.cli.CommandLine commandLine) {
        try {
            if (commandLine.getOptions().length == 0) {
                if (this.isStorageInstalled()) {
                    this.startStorage();
                }
                if (this.isServerInstalled()) {
                    this.startRHQServer();
                }
                if (this.isAgentInstalled()) {
                    this.startAgent();
                }
            } else {
                if (commandLine.hasOption("storage")) {
                    if (this.isStorageInstalled()) {
                        this.startStorage();
                    } else {
                        this.log.warn((Object)"It appears that the storage node is not installed. The --storage option will be ignored.");
                    }
                }
                if (commandLine.hasOption("server")) {
                    if (this.isServerInstalled()) {
                        this.startRHQServer();
                    } else {
                        this.log.warn((Object)"It appears that the server is not installed. The --server option will be ignored.");
                    }
                }
                if (commandLine.hasOption("agent")) {
                    if (this.isAgentInstalled()) {
                        this.startAgent();
                    } else {
                        this.log.warn((Object)"It appears that the agent is not installed. The --agent option will be ignored.");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RHQControlException("Failed to stop services", e);
        }
    }

    private void startStorage() throws Exception {
        this.log.debug((Object)"Starting RHQ storage node");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        if (this.isWindows()) {
            executor.setWorkingDirectory(this.getBinDir());
            CommandLine commandLine = this.getCommandLine("rhq-storage", "start");
            try {
                executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to start storage service", (Throwable)e);
            }
        } else {
            File storageBinDir = new File(this.getStorageBasedir(), "bin");
            File pidFile = new File(storageBinDir, "cassandra.pid");
            if (pidFile.exists()) {
                String pid = StreamUtil.slurp((Reader)new FileReader(pidFile));
                System.out.println("RHQ storage node (pid " + pid + ") is running");
            } else {
                CommandLine commandLine = this.getCommandLine(false, "cassandra", "-p", pidFile.getAbsolutePath());
                executor.setWorkingDirectory(storageBinDir);
                executor.execute(commandLine);
            }
        }
    }

    private void startRHQServer() throws Exception {
        this.log.debug((Object)"Starting RHQ server");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.getBinDir());
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine commandLine = this.getCommandLine("rhq-server", "start");
        if (this.isWindows()) {
            try {
                executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to start server service", (Throwable)e);
            }
        } else {
            executor.execute(commandLine);
        }
    }

    private void startAgent() throws Exception {
        this.log.debug((Object)"Starting RHQ agent");
        File agentBinDir = new File(this.getAgentBasedir(), "bin");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(agentBinDir);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "start");
        if (this.isWindows()) {
            try {
                executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to start agent service", (Throwable)e);
            }
        } else {
            executor.execute(commandLine);
        }
    }
}

