/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.Options;
import org.apache.commons.exec.CommandLine;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.file.FileReverter;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.file.FileVisitor;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;
import org.rhq.server.control.command.AbstractInstall;
import org.rhq.server.control.command.Stop;
import org.rhq.server.control.util.ExecutorAssist;

public class Upgrade
extends AbstractInstall {
    private static final String FROM_AGENT_DIR_OPTION = "from-agent-dir";
    private static final String FROM_SERVER_DIR_OPTION = "from-server-dir";
    private static final String USE_REMOTE_STORAGE_NODE = "use-remote-storage-node";
    private static final String STORAGE_DATA_ROOT_DIR = "storage-data-root-dir";
    private static final String RUN_DATA_MIGRATION = "run-data-migrator";
    private Options options = new Options().addOption(null, "from-agent-dir", true, "Full path to install directory of the RHQ Agent to be upgraded. Required only if an existing agent exists and is not installed in the default location: <from-server-dir>/../rhq-agent").addOption(null, "from-server-dir", true, "Full path to install directory of the RHQ Server to be upgraded. Required.").addOption(null, "start", false, "If specified then immediately start the services after upgrade.  Note that services may be started and shut down as part of the upgrade process, but will not be started or left running by default.").addOption(null, "use-remote-storage-node", true, "By default a server is co-located with a storage node. However, if this option is set to true, no local storage node will be upgraded and it is assumed a remote storage node is configured in rhq-server.properties.").addOption(null, "storage-data-root-dir", true, "This option is valid only when upgrading from older systems that did not have storage nodes. Use this option to specify a non-default base directory for the data directories created by the storage node. For example, if the default directory is not writable for the current user (/var/lib on Linux) or if you simply prefer a different location. ").addOption(null, "run-data-migrator", true, "This option is valid only when upgrading from older systems that did not have storage nodes. The existing metric data needs to migrate to the metric storage.  The upgrade process can trigger this or give you an estimate on the duration. If you want to have fine control over the process, please run the migrator on the command line. Options are none (do nothing), estimate (estimate the migration time only), print-command (print the command line for a manual run), do-it (run the migration)");

    @Override
    public String getName() {
        return "upgrade";
    }

    @Override
    public String getDescription() {
        return "Upgrades RHQ services from an earlier installed version";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    protected String getReadmeFilename() {
        return "UPGRADE_README.txt";
    }

    /*
     * Loose catch block
     */
    @Override
    protected int exec(org.apache.commons.cli.CommandLine commandLine) {
        int rValue;
        block36: {
            boolean start;
            block35: {
                block34: {
                    CommandLine rhqctlStop;
                    File fromBinDir;
                    int exitValue;
                    boolean hasFromAgentOption;
                    block33: {
                        block32: {
                            rValue = 0;
                            start = commandLine.hasOption("start");
                            List<String> errors = this.validateOptions(commandLine);
                            if (errors.isEmpty()) break block32;
                            for (String error : errors) {
                                this.log.error((Object)error);
                            }
                            this.log.error((Object)"Exiting due to the previous errors");
                            int i$ = 1;
                            try {
                                if (!start) {
                                    Stop stopCommand = new Stop();
                                    stopCommand.exec(new String[]{"--server"});
                                    if (!commandLine.hasOption(RUN_DATA_MIGRATION)) {
                                        rValue = Math.max(rValue, stopCommand.exec(new String[]{"--storage"}));
                                    }
                                }
                            }
                            catch (Throwable t) {
                                this.log.warn((Object)("Unable to stop services: " + t.getMessage()));
                                rValue = 1;
                            }
                            return i$;
                        }
                        this.log.info((Object)"Stopping any running RHQ components...");
                        hasFromAgentOption = commandLine.hasOption(FROM_AGENT_DIR_OPTION);
                        if (hasFromAgentOption) {
                            File agentBasedir = Upgrade.getFromAgentDir(commandLine);
                            this.setAgentBasedir(agentBasedir);
                        }
                        if (!this.isStorageInstalled() && !this.isServerInstalled()) break block33;
                        this.log.warn((Object)"RHQ is already installed so upgrade can not be performed.");
                        int agentBasedir = 1;
                        try {
                            if (!start) {
                                Stop stopCommand = new Stop();
                                stopCommand.exec(new String[]{"--server"});
                                if (!commandLine.hasOption(RUN_DATA_MIGRATION)) {
                                    rValue = Math.max(rValue, stopCommand.exec(new String[]{"--storage"}));
                                }
                            }
                        }
                        catch (Throwable t) {
                            this.log.warn((Object)("Unable to stop services: " + t.getMessage()));
                            rValue = 1;
                        }
                        return agentBasedir;
                    }
                    this.log.info((Object)"Stopping any running RHQ components...");
                    if (hasFromAgentOption) {
                        rValue = Math.max(rValue, this.killAgent(Upgrade.getFromAgentDir(commandLine)));
                    }
                    if ((exitValue = ExecutorAssist.execute(fromBinDir = new File(Upgrade.getFromServerDir(commandLine), "bin"), rhqctlStop = this.isRhq48OrLater(commandLine) ? this.getCommandLine(false, "rhqctl", "stop") : this.getCommandLine("rhq-server", "stop"))) == 0) {
                        this.log.info((Object)"The old installation components have been stopped");
                        break block34;
                    }
                    this.log.error((Object)("The old installation components failed to be stopped. Please stop them manually before continuing. exit code=" + exitValue));
                    int n = exitValue;
                    try {
                        if (!start) {
                            Stop stopCommand = new Stop();
                            stopCommand.exec(new String[]{"--server"});
                            if (!commandLine.hasOption(RUN_DATA_MIGRATION)) {
                                rValue = Math.max(rValue, stopCommand.exec(new String[]{"--storage"}));
                            }
                        }
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Unable to stop services: " + t.getMessage()));
                        rValue = 1;
                    }
                    return n;
                }
                final FileReverter serverPropFileReverter = new FileReverter(this.getServerPropertiesFile());
                this.addUndoTask(new ControlCommand.UndoTask("Reverting server properties file"){

                    @Override
                    public void performUndoWork() throws Exception {
                        try {
                            serverPropFileReverter.revert();
                        }
                        catch (Exception e) {
                            throw new Exception("Cannot reset rhq-server.properties - revert settings manually", e);
                        }
                    }
                });
                this.upgradeServerEnvFile(commandLine);
                rValue = Math.max(rValue, this.upgradeStorage(commandLine));
                rValue = Math.max(rValue, this.upgradeServer(commandLine));
                rValue = Math.max(rValue, this.upgradeAgent(commandLine));
                File agentDir = commandLine.hasOption(FROM_AGENT_DIR_OPTION) ? new File(commandLine.getOptionValue(FROM_AGENT_DIR_OPTION)) : this.getAgentBasedir();
                this.updateWindowsAgentService(agentDir);
                if (!start) break block35;
                rValue = Math.max(rValue, this.startAgent(agentDir));
            }
            try {
                if (!start) {
                    Stop stopCommand = new Stop();
                    stopCommand.exec(new String[]{"--server"});
                    if (!commandLine.hasOption(RUN_DATA_MIGRATION)) {
                        rValue = Math.max(rValue, stopCommand.exec(new String[]{"--storage"}));
                    }
                }
                break block36;
            }
            catch (Throwable t) {
                this.log.warn((Object)("Unable to stop services: " + t.getMessage()));
                rValue = 1;
            }
            break block36;
            catch (Exception e) {
                try {
                    throw new RHQControlException("An error occurred while executing the upgrade command", e);
                }
                catch (Throwable throwable) {
                    try {
                        if (!start) {
                            Stop stopCommand = new Stop();
                            stopCommand.exec(new String[]{"--server"});
                            if (!commandLine.hasOption(RUN_DATA_MIGRATION)) {
                                rValue = Math.max(rValue, stopCommand.exec(new String[]{"--storage"}));
                            }
                        }
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Unable to stop services: " + t.getMessage()));
                        rValue = 1;
                    }
                    throw throwable;
                }
            }
        }
        if (!this.isRhq48OrLater(commandLine) && commandLine.hasOption(RUN_DATA_MIGRATION)) {
            rValue = Math.max(rValue, this.runDataMigration(commandLine));
        }
        return rValue;
    }

    private int runDataMigration(org.apache.commons.cli.CommandLine rhqctlCommandLine) {
        int rValue;
        String migrationOption = rhqctlCommandLine.getOptionValue(RUN_DATA_MIGRATION);
        if (migrationOption.equals("none")) {
            this.log.info((Object)"No data migration will run");
            if (!this.isRhq48OrLater(rhqctlCommandLine)) {
                this.printDataMigrationNotice();
            }
            return 0;
        }
        try {
            CommandLine commandLine = this.getCommandLine("rhq-data-migration", new String[0]);
            commandLine.addArgument("-X");
            if (migrationOption.equals("estimate")) {
                commandLine.addArgument("--estimate-only");
            }
            int exitValue = ExecutorAssist.execute(new File(this.getBaseDir(), "bin"), commandLine);
            this.log.info((Object)("The data migrator finished with exit value " + exitValue));
            rValue = exitValue;
        }
        catch (Exception e) {
            this.log.error((Object)("Running the data migrator failed - please try to run it from the command line: " + e.getMessage()));
            rValue = 1;
        }
        return rValue;
    }

    private int upgradeStorage(org.apache.commons.cli.CommandLine rhqctlCommandLine) throws Exception {
        int rValue;
        if (rhqctlCommandLine.hasOption(USE_REMOTE_STORAGE_NODE)) {
            this.log.info((Object)"Ignoring storage node upgrade, a remote storage node is configured.");
            return 0;
        }
        if (this.isRhq48OrLater(rhqctlCommandLine)) {
            try {
                this.waitForProcessToStop(this.getStoragePid());
                this.addUndoTaskToStopComponent("--storage");
                this.addUndoTask(new ControlCommand.UndoTask("Removing new storage node install directory"){

                    @Override
                    public void performUndoWork() {
                        FileUtil.purge((File)Upgrade.this.getStorageBasedir(), (boolean)true);
                    }
                });
                CommandLine commandLine = this.getCommandLine("rhq-storage-installer", "--upgrade", Upgrade.getFromServerDir(rhqctlCommandLine).getAbsolutePath());
                rValue = ExecutorAssist.execute(this.getBinDir(), commandLine);
                this.log.info((Object)("The storage node upgrade has finished with an exit value of " + rValue));
            }
            catch (IOException e) {
                this.log.error((Object)("An error occurred while running the storage node upgrade: " + e.getMessage()));
                throw e;
            }
        } else {
            rValue = this.installStorageNode(this.getStorageBasedir(), rhqctlCommandLine, true);
        }
        return rValue;
    }

    private int upgradeServer(org.apache.commons.cli.CommandLine commandLine) throws Exception {
        File oldServerDir = Upgrade.getFromServerDir(commandLine);
        if (this.isRhq48OrLater(commandLine) && !this.isServerInstalled(oldServerDir)) {
            this.log.info((Object)"Ignoring server upgrade, this is a storage node only installation.");
            return 0;
        }
        this.upgradeServerPropertiesFile(commandLine);
        int rValue = 0;
        try {
            this.copyOracleDriver(oldServerDir);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to copy the old Oracle driver to the new server. The upgrade will continue but your server may not work if connecting to an Oracle database, in which case you will need to manually install an Oracle driver to your server. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
            rValue = 1;
        }
        File oldWrapperIncFile = new File(oldServerDir, "bin/wrapper/rhq-server-wrapper.inc");
        if (oldWrapperIncFile.exists()) {
            File newWrapperIncFile = new File(this.getBaseDir(), "bin/wrapper/rhq-server-wrapper.inc");
            FileUtil.copyFile((File)oldWrapperIncFile, (File)newWrapperIncFile);
        }
        rValue = Math.max(rValue, this.startRHQServerForInstallation());
        int installerStatusCode = this.runRHQServerInstaller();
        rValue = Math.max(rValue, installerStatusCode);
        if (installerStatusCode == 0) {
            this.waitForRHQServerToInitialize();
        }
        return rValue;
    }

    public void copyOracleDriver(File oldServerDir) throws IOException {
        String oracleModuleRelativePath = "modules/org/rhq/oracle";
        File newOracleModuleDir = new File(this.getBaseDir(), oracleModuleRelativePath);
        File newOracleModuleMainDir = new File(newOracleModuleDir, "main");
        for (File f : newOracleModuleMainDir.listFiles()) {
            boolean foundRealOracleDriver;
            boolean bl = foundRealOracleDriver = f.isFile() && f.length() > 100000L;
            if (!foundRealOracleDriver) continue;
            this.log.info((Object)("Looks like the new server already has an Oracle driver: " + f));
            return;
        }
        File oldOracleModuleDir = new File(oldServerDir, oracleModuleRelativePath);
        if (oldOracleModuleDir.isDirectory()) {
            FileUtil.purge((File)newOracleModuleDir, (boolean)true);
            FileUtil.copyDirectory((File)oldOracleModuleDir, (File)newOracleModuleDir);
            this.log.info((Object)("Copied the old Oracle JDBC module [" + oldOracleModuleDir + "] to the new server: " + newOracleModuleDir));
        } else {
            FilenameFilter oracleDriverFilenameFilter;
            File[] oracleDriver;
            File oldLibDir = new File(oldServerDir, "jbossas/server/default/lib");
            if (oldLibDir.isDirectory() && (oracleDriver = oldLibDir.listFiles(oracleDriverFilenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("ojdbc") && name.endsWith(".jar");
                }
            })) != null && oracleDriver.length > 0) {
                File[] dummy;
                if (oracleDriver.length > 1) {
                    this.log.warn((Object)("It appears that more than one oracle driver exists in the old server at [" + oldLibDir + "]; this one will be reused: " + oracleDriver[0]));
                }
                if ((dummy = newOracleModuleMainDir.listFiles(oracleDriverFilenameFilter)) != null) {
                    for (File dummyFileToDelete : dummy) {
                        dummyFileToDelete.delete();
                    }
                }
                File newOracleJarFile = new File(newOracleModuleMainDir, oracleDriver[0].getName());
                FileUtil.copyFile((File)oracleDriver[0], (File)newOracleJarFile);
                this.log.info((Object)("Copied the old Oracle JDBC driver [" + oracleDriver[0] + "] to the new server: " + newOracleJarFile));
                File moduleXmlFile = new File(newOracleModuleMainDir, "module.xml");
                String originalXml = new String(StreamUtil.slurp((InputStream)new FileInputStream(moduleXmlFile)));
                String newXml = originalXml.replaceFirst("resource-root path.*=.*\"ojdbc.*jar\"", "resource-root path=\"" + oracleDriver[0].getName() + "\"");
                FileUtil.writeFile((InputStream)new ByteArrayInputStream(newXml.getBytes()), (File)moduleXmlFile);
                this.log.info((Object)("Updated module.xml [" + moduleXmlFile + "] to use the proper Oracle driver"));
            }
        }
    }

    private void upgradeServerEnvFile(org.apache.commons.cli.CommandLine commandLine) throws Exception {
        String[] envFiles;
        File oldServerDir = Upgrade.getFromServerDir(commandLine);
        for (String envFile : envFiles = new String[]{"bin/rhq-server-env.sh", "bin/rhq-server-env.bat"}) {
            File oldServerEnvFile = new File(oldServerDir, envFile);
            if (!oldServerEnvFile.exists()) continue;
            File newServerEnvFile = new File(this.getBaseDir(), envFile);
            File newServerEnvFileBackup = new File(this.getBaseDir(), envFile + ".default");
            try {
                FileUtil.copyFile((File)newServerEnvFile, (File)newServerEnvFileBackup);
                newServerEnvFile.delete();
                FileUtil.copyFile((File)oldServerEnvFile, (File)newServerEnvFile);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to update [" + oldServerEnvFile + "] to [" + newServerEnvFile + "]. Settings in + [" + oldServerEnvFile + "] + will not be applied to the upgrade. " + "You will need to manually copy the file to the new location after the upgrade."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeServerPropertiesFile(org.apache.commons.cli.CommandLine commandLine) throws Exception {
        String storageCompression;
        String storageSeeds;
        String storagePassword;
        String storageUsername;
        String httpsPort;
        String[] algPropNames;
        File oldServerDir = Upgrade.getFromServerDir(commandLine);
        File oldServerPropsFile = new File(oldServerDir, "bin/rhq-server.properties");
        Properties oldServerProps = new Properties();
        FileInputStream oldServerPropsFileInputStream = new FileInputStream(oldServerPropsFile);
        try {
            oldServerProps.load(oldServerPropsFileInputStream);
        }
        finally {
            oldServerPropsFileInputStream.close();
        }
        oldServerProps.setProperty("rhq.autoinstall.enabled", "true");
        oldServerProps.setProperty("rhq.autoinstall.database", "auto");
        oldServerProps.remove("rhq.server.embedded-agent.name");
        oldServerProps.remove("rhq.server.embedded-agent.reset-configuration");
        oldServerProps.remove("rhq.server.embedded-agent.disable-native-system");
        oldServerProps.remove("rhq.server.embedded-agent.enabled");
        oldServerProps.remove("rhq.server.startup.jrmpinvoker.rmiport");
        oldServerProps.remove("rhq.server.startup.webservice.port");
        oldServerProps.remove("rhq.server.startup.unifiedinvoker.port");
        oldServerProps.remove("rhq.server.startup.namingservice.rmiport");
        oldServerProps.remove("rhq.server.startup.pooledinvoker.rmiport");
        oldServerProps.remove("rhq.server.startup.ajp.port");
        oldServerProps.remove("rhq.server.startup.namingservice.port");
        oldServerProps.remove("rhq.server.startup.aspectdeployer.bind-port");
        oldServerProps.remove("rhq.server.plugin-deployer-threads");
        oldServerProps.remove("rhq.server.database.xa-datasource-class");
        oldServerProps.remove("rhq.server.database.driver-class");
        oldServerProps.remove("java.rmi.server.hostname");
        for (String algPropName : algPropNames = new String[]{"rhq.communications.connector.security.truststore.algorithm", "rhq.communications.connector.security.keystore.algorithm", "rhq.server.client.security.keystore.algorithm", "rhq.server.client.security.truststore.algorithm", "rhq.server.tomcat.security.algorithm"}) {
            String algValue = oldServerProps.getProperty(algPropName, "SunX509");
            if (!algValue.equals("SunX509") && !algValue.equals("IbmX509")) continue;
            oldServerProps.remove(algPropName);
        }
        String httpPort = oldServerProps.getProperty("rhq.server.startup.web.http.port");
        if (httpPort != null) {
            oldServerProps.remove("rhq.server.startup.web.http.port");
            oldServerProps.setProperty("rhq.server.socket.binding.port.http", httpPort);
        }
        if ((httpsPort = oldServerProps.getProperty("rhq.server.startup.web.https.port")) != null) {
            oldServerProps.remove("rhq.server.startup.web.https.port");
            oldServerProps.setProperty("rhq.server.socket.binding.port.https", httpsPort);
        }
        if ((storageUsername = oldServerProps.getProperty("rhq.cassandra.username")) != null) {
            oldServerProps.remove("rhq.cassandra.username");
            oldServerProps.setProperty("rhq.storage.username", storageUsername);
        }
        if ((storagePassword = oldServerProps.getProperty("rhq.cassandra.password")) != null) {
            oldServerProps.remove("rhq.cassandra.password");
            oldServerProps.setProperty("rhq.storage.password", "1eeb2f255e832171df8592078de921bc");
        }
        if ((storageSeeds = oldServerProps.getProperty("rhq.cassandra.seeds")) != null) {
            StringBuffer storageNodes = new StringBuffer();
            String cqlPort = "";
            String[] unparsedNodes = storageSeeds.split(",");
            for (int index = 0; index < unparsedNodes.length; ++index) {
                String[] params = unparsedNodes[index].split("\\|");
                if (params.length != 3) continue;
                storageNodes.append(params[0]);
                if (index < unparsedNodes.length - 1) {
                    storageNodes.append(",");
                }
                cqlPort = params[2];
            }
            oldServerProps.remove("rhq.cassandra.seeds");
            oldServerProps.setProperty("rhq.storage.nodes", storageNodes.toString());
            oldServerProps.setProperty("rhq.storage.cql-port", cqlPort);
        }
        if ((storageCompression = oldServerProps.getProperty("rhq.cassandra.client.compression-enabled")) != null) {
            oldServerProps.remove("rhq.cassandra.client.compression-enabled");
            oldServerProps.setProperty("rhq.storage.client.compression-enabled", storageCompression);
        }
        this.copyReferredFile(commandLine, oldServerProps, "rhq.server.tomcat.security.keystore.file");
        this.copyReferredFile(commandLine, oldServerProps, "rhq.server.tomcat.security.truststore.file");
        this.copyReferredFile(commandLine, oldServerProps, "rhq.communications.connector.security.keystore.file");
        this.copyReferredFile(commandLine, oldServerProps, "rhq.communications.connector.security.truststore.file");
        this.copyReferredFile(commandLine, oldServerProps, "rhq.server.client.security.keystore.file");
        this.copyReferredFile(commandLine, oldServerProps, "rhq.server.client.security.truststore.file");
        String dbType = oldServerProps.getProperty("rhq.server.database.type-mapping");
        if (null != dbType && dbType.toLowerCase().contains("oracle")) {
            oldServerProps.setProperty("rhq.server.database.server-name", "unused");
            oldServerProps.setProperty("rhq.server.database.port", "unused");
            oldServerProps.setProperty("rhq.server.database.db-name", "unused");
        }
        String newServerPropsFilePath = this.getServerPropertiesFile().getAbsolutePath();
        PropertiesFileUpdate newServerPropsFile = new PropertiesFileUpdate(newServerPropsFilePath);
        newServerPropsFile.update(oldServerProps);
    }

    private void copyReferredFile(org.apache.commons.cli.CommandLine commandLine, Properties properties, String propertyName) {
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null || propertyValue.trim().length() == 0) {
            return;
        }
        File referredFile = new File(propertyValue);
        boolean originalFilePathIsAbsolute = referredFile.isAbsolute();
        if (!originalFilePathIsAbsolute) {
            File oldServerConfigDir = new File(Upgrade.getFromServerDir(commandLine), "jbossas/standalone/configuration");
            if (!oldServerConfigDir.isDirectory() && !(oldServerConfigDir = new File(Upgrade.getFromServerDir(commandLine), "jbossas/server/default/conf")).isDirectory()) {
                this.log.warn((Object)("Cannot determine the old server's configuration directory - cannot copy over the old file: " + referredFile));
                return;
            }
            String absPath = propertyValue.replace("${jboss.server.config.dir}", oldServerConfigDir.getAbsolutePath());
            if ((absPath = absPath.replace("${jboss.server.home.dir}/conf", this.useForwardSlash(oldServerConfigDir.getAbsolutePath()))).startsWith("conf/")) {
                absPath = absPath.replaceFirst("conf", this.useForwardSlash(oldServerConfigDir.getAbsolutePath()));
            }
            referredFile = new File(absPath);
        }
        if (!referredFile.isFile()) {
            this.log.info((Object)("Server property [" + propertyName + "] refers to file [" + referredFile + "] that does not exist. Skipping."));
            return;
        }
        File newServerConfigDir = new File(this.getBaseDir(), "jbossas/standalone/configuration");
        File newFile = new File(newServerConfigDir, referredFile.getName());
        try {
            FileUtil.copyFile((File)referredFile, (File)newFile);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to copy the old file [" + referredFile + "] referred to by server property [" + propertyName + "] to the new location of [" + newFile + "]. You will need to manually copy that file to the new location." + "The server may not work properly until you do this."));
        }
        properties.setProperty(propertyName, "${jboss.server.config.dir}/" + newFile.getName());
    }

    private String useForwardSlash(String path) {
        return null != path ? path.replace('\\', '/') : null;
    }

    private int upgradeAgent(org.apache.commons.cli.CommandLine rhqctlCommandLine) throws Exception {
        try {
            File oldAgentDir;
            if (rhqctlCommandLine.hasOption(FROM_AGENT_DIR_OPTION)) {
                oldAgentDir = new File(rhqctlCommandLine.getOptionValue(FROM_AGENT_DIR_OPTION));
                if (!oldAgentDir.isDirectory()) {
                    throw new FileNotFoundException("Missing agent to upgrade: " + oldAgentDir.getAbsolutePath());
                }
            } else {
                File fromServerDirParent;
                oldAgentDir = null;
                File fromServerDir = Upgrade.getFromServerDir(rhqctlCommandLine);
                if (fromServerDir != null && fromServerDir.isDirectory() && (fromServerDirParent = fromServerDir.getParentFile()) != null && fromServerDirParent.isDirectory()) {
                    oldAgentDir = new File(fromServerDirParent, "rhq-agent");
                }
                if (!oldAgentDir.isDirectory()) {
                    this.log.info((Object)("No from-agent-dir option specified and no agent found in the default location [" + oldAgentDir.getAbsolutePath() + "]. Installing agent in the default location as part of the upgrade."));
                    return this.installAgent(this.getAgentBasedir(), rhqctlCommandLine);
                }
            }
            this.log.info((Object)("Upgrading RHQ agent located at: " + oldAgentDir.getAbsolutePath()));
            final File agentBasedir = this.getAgentBasedir();
            File agentInstallerJar = this.getFileDownload("rhq-agent", "rhq-enterprise-agent");
            String javaExeFilePath = System.getProperty("rhq.java-exe-file-path");
            CommandLine commandLine = new CommandLine(javaExeFilePath).addArgument("-jar").addArgument(agentInstallerJar.getAbsolutePath()).addArgument("--update=" + oldAgentDir.getAbsolutePath()).addArgument("--log=" + new File(this.getLogDir(), "rhq-agent-update.log")).addArgument("--launch=false");
            int exitValue = ExecutorAssist.execute(this.getBaseDir(), commandLine);
            this.log.info((Object)("The agent installer finished upgrading with exit value " + exitValue));
            if (!agentBasedir.equals(oldAgentDir)) {
                FileUtil.purge((File)agentBasedir, (boolean)true);
                if (!oldAgentDir.renameTo(agentBasedir)) {
                    FileUtil.copyDirectory((File)oldAgentDir, (File)agentBasedir);
                    FileVisitor visitor = new FileVisitor(){

                        public void visit(File file) {
                            String filename = file.getName();
                            if (filename.contains(".so") || filename.contains(".sl") || filename.contains(".dylib")) {
                                file.setExecutable(true);
                            } else if (filename.endsWith(".sh")) {
                                file.setExecutable(true);
                            }
                        }
                    };
                    FileUtil.forEachFile((File)new File(agentBasedir, "bin"), (FileVisitor)visitor);
                    FileUtil.forEachFile((File)new File(agentBasedir, "lib"), (FileVisitor)visitor);
                }
            }
            this.addUndoTask(new ControlCommand.UndoTask("Removing agent install directory"){

                @Override
                public void performUndoWork() {
                    FileUtil.purge((File)agentBasedir, (boolean)true);
                }
            });
            this.log.info((Object)("The agent has been upgraded and placed in: " + agentBasedir));
            return exitValue;
        }
        catch (IOException e) {
            this.log.error((Object)("An error occurred while upgrading the agent: " + e.getMessage()));
            throw e;
        }
    }

    private File getFileDownload(String directory, final String fileMatch) {
        File downloadDir = new File(this.getBaseDir(), "modules/org/rhq/server-startup/main/deployments/rhq.ear/rhq-downloads/" + directory);
        return downloadDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().contains(fileMatch);
            }
        })[0];
    }

    private List<String> validateOptions(org.apache.commons.cli.CommandLine commandLine) {
        LinkedList<String> errors = new LinkedList<String>();
        if (!commandLine.hasOption(FROM_SERVER_DIR_OPTION)) {
            errors.add("Missing required option: from-server-dir");
        } else {
            File fromServerDir = new File(commandLine.getOptionValue(FROM_SERVER_DIR_OPTION));
            if (!fromServerDir.isDirectory()) {
                errors.add("The from-server-dir directory does not exist: [" + fromServerDir.getPath() + "]");
            } else {
                File serverPropsFile = new File(fromServerDir, "bin/rhq-server.properties");
                if (!serverPropsFile.isFile()) {
                    errors.add("The from-server-dir directory does not appear to be an RHQ installation. Missing expected file: [" + serverPropsFile.getPath() + "]");
                }
            }
        }
        if (this.isRhq48OrLater(commandLine)) {
            if (commandLine.hasOption(STORAGE_DATA_ROOT_DIR)) {
                errors.add("The option --storage-data-root-dir is valid only for upgrades from older systems that did not have storage nodes.");
            }
            if (commandLine.hasOption(RUN_DATA_MIGRATION)) {
                errors.add("The option --run-data-migrator is valid only for upgrades from older systems that did not have storage nodes.");
            }
        }
        if (commandLine.hasOption(FROM_AGENT_DIR_OPTION)) {
            File fromAgentDir = new File(commandLine.getOptionValue(FROM_AGENT_DIR_OPTION));
            if (!fromAgentDir.isDirectory()) {
                errors.add("The from-agent-dir directory does not exist: [" + fromAgentDir.getPath() + "]");
            } else {
                String agentEnvFileName = File.separatorChar == '/' ? "bin/rhq-agent-env.sh" : "bin/rhq-agent-env.bat";
                File agentEnvFile = new File(fromAgentDir, agentEnvFileName);
                if (!agentEnvFile.isFile()) {
                    errors.add("The from-agent-dir directory does not appear to be an RHQ Agent installation. Missing expected file: [" + agentEnvFile.getPath() + "]");
                }
            }
        }
        return errors;
    }

    public static File getFromAgentDir(org.apache.commons.cli.CommandLine commandLine) {
        return commandLine.hasOption(FROM_AGENT_DIR_OPTION) ? new File(commandLine.getOptionValue(FROM_AGENT_DIR_OPTION)) : null;
    }

    public static File getFromServerDir(org.apache.commons.cli.CommandLine commandLine) {
        return commandLine.hasOption(FROM_SERVER_DIR_OPTION) ? new File(commandLine.getOptionValue(FROM_SERVER_DIR_OPTION)) : null;
    }

    protected boolean isRhq48OrLater(org.apache.commons.cli.CommandLine commandLine) {
        return new File(Upgrade.getFromServerDir(commandLine), "bin/rhqctl").exists();
    }

    protected boolean isRhq410OrLater(org.apache.commons.cli.CommandLine commandLine) {
        return new File(Upgrade.getFromServerDir(commandLine), "bin/internal").isDirectory();
    }

    private void printDataMigrationNotice() {
        this.log.info((Object)"\n================\nIf this was an upgrade from older systems that did not have storage nodes,\n you need to run the data migration job to transfer stored (historic)\nmetrics data from the relational database into the new storage.\nUntil the migration has run, that historic data is not available \nin e.g. the charting views.\n\nTo run the data migration, just run rhq-data-migration.{sh|bat}\nscript located in the server bin folder.\n================\n");
    }
}

