/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.File;
import org.apache.commons.cli.Options;
import org.apache.commons.exec.CommandLine;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;
import org.rhq.server.control.util.ExecutorAssist;

public class Remove
extends ControlCommand {
    private Options options = new Options().addOption(null, "storage", false, "Remove RHQ storage node service").addOption(null, "server", false, "Remove RHQ server service").addOption(null, "agent", false, "Remove RHQ agent service");

    @Override
    public String getName() {
        return "remove";
    }

    @Override
    public String getDescription() {
        return "Removes RHQ services on Windows.";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    protected String getReadmeFilename() {
        return "REMOVE_README.txt";
    }

    @Override
    protected int exec(org.apache.commons.cli.CommandLine commandLine) {
        int rValue = 0;
        try {
            if (commandLine.getOptions().length == 0) {
                if (this.isAgentInstalled()) {
                    rValue = Math.max(rValue, this.removeAgentService());
                }
                rValue = Math.max(rValue, this.removeServerService());
                if (this.isStorageInstalled()) {
                    rValue = Math.max(rValue, this.removeStorageService());
                }
            } else {
                if (commandLine.hasOption("agent")) {
                    if (this.isAgentInstalled()) {
                        rValue = Math.max(rValue, this.removeAgentService());
                    } else {
                        this.log.warn((Object)"It appears that the agent is not installed. The --agent option will be ignored.");
                        rValue = 2;
                    }
                }
                if (commandLine.hasOption("server")) {
                    rValue = Math.max(rValue, this.removeServerService());
                }
                if (commandLine.hasOption("storage")) {
                    if (this.isStorageInstalled()) {
                        rValue = Math.max(rValue, this.removeStorageService());
                    } else {
                        this.log.warn((Object)"It appears that the storage node is not installed. The --storage option will be ignored.");
                        rValue = 2;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RHQControlException("Failed to stop services", e);
        }
        return rValue;
    }

    private int removeStorageService() throws Exception {
        int rValue;
        this.log.debug((Object)"Stopping RHQ storage node");
        if (this.isWindows()) {
            CommandLine commandLine = this.getCommandLine("rhq-storage", "remove");
            try {
                rValue = ExecutorAssist.execute(this.getBinDir(), commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to remove storage service", (Throwable)e);
                rValue = 1;
            }
        } else {
            String pid = this.getStoragePid();
            if (pid != null) {
                System.out.println("Stopping RHQ storage node...");
                System.out.println("RHQ storage node (pid=" + pid + ") is stopping...");
                CommandLine commandLine = new CommandLine("kill").addArgument(pid);
                rValue = ExecutorAssist.execute(this.getBinDir(), commandLine);
                System.out.println("RHQ storage node has stopped");
            } else {
                rValue = 0;
            }
        }
        return rValue;
    }

    private int removeServerService() throws Exception {
        int rValue;
        this.log.debug((Object)"Stopping RHQ server");
        if (this.isWindows()) {
            try {
                CommandLine commandLine = this.getCommandLine("rhq-server", "remove");
                rValue = ExecutorAssist.execute(this.getBinDir(), commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to remove server service", (Throwable)e);
                rValue = 1;
            }
        } else {
            String pid = this.getServerPid();
            if (pid != null) {
                CommandLine commandLine = this.getCommandLine("rhq-server", "stop");
                rValue = ExecutorAssist.execute(this.getBinDir(), commandLine);
            } else {
                rValue = 0;
            }
        }
        return rValue;
    }

    private int removeAgentService() throws Exception {
        int rValue;
        this.log.debug((Object)"Stopping RHQ agent");
        File agentBinDir = new File(this.getAgentBasedir(), "bin");
        if (this.isWindows()) {
            try {
                CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "remove");
                rValue = ExecutorAssist.execute(agentBinDir, commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to remove agent service", (Throwable)e);
                rValue = 1;
            }
        } else {
            String pid = this.getAgentPid();
            if (pid != null) {
                CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "stop");
                rValue = ExecutorAssist.execute(agentBinDir, commandLine);
            } else {
                rValue = 0;
            }
        }
        return rValue;
    }
}

