/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.ProcExe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.postgres.util.PostgresqlConfFile;

public class PostgresDiscoveryComponent
implements ResourceDiscoveryComponent,
ManualAddFacet {
    private static final Log log = LogFactory.getLog(PostgresDiscoveryComponent.class);
    public static final String PGDATA_DIR_CONFIGURATION_PROPERTY = "pgdataDir";
    public static final String CONFIG_FILE_CONFIGURATION_PROPERTY = "configFile";
    public static final String DRIVER_CONFIGURATION_PROPERTY = "driverClass";
    public static final String HOST_CONFIGURATION_PROPERTY = "host";
    public static final String PORT_CONFIGURATION_PROPERTY = "port";
    public static final String DB_CONFIGURATION_PROPERTY = "db";
    public static final String PRINCIPAL_CONFIGURATION_PROPERTY = "principal";
    public static final String CREDENTIALS_CONFIGURATION_PROPERTY = "credentials";
    private static final String PGDATA_ENV_VAR = "PGDATA";
    private static final String DEFAULT_RESOURCE_DESCRIPTION = "Postgres relational database server";
    private static final String POSTGRES_DEFAULT_DATABASE_NAME = "postgres";
    private static final Pattern VERSION_FROM_COMMANDLINE = Pattern.compile("\\d+(?:\\.\\d+)*");

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        LinkedHashSet<DiscoveredResourceDetails> servers = new LinkedHashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = context.getAutoDiscoveredProcesses();
        for (ProcessScanResult result : autoDiscoveryResults) {
            log.info((Object)("Discovered a postgres process: " + result));
            ProcessInfo procInfo = result.getProcessInfo();
            String pgDataPath = PostgresDiscoveryComponent.getDataDirPath(procInfo);
            if (pgDataPath == null) {
                log.error((Object)("Unable to obtain data directory for postgres process with pid " + procInfo.getPid() + " (tried checking both -D command line argument, as well as " + PGDATA_ENV_VAR + " environment variable)."));
                continue;
            }
            File pgData = new File(pgDataPath);
            String configFilePath = PostgresDiscoveryComponent.getConfigFilePath(procInfo);
            PostgresqlConfFile confFile = null;
            if (!pgData.exists()) {
                log.warn((Object)("PostgreSQL data directory (" + pgData + ") does not exist or is not readable. " + "Make sure the user the RHQ Agent is running as has read permissions on the directory and its parent directory."));
            } else {
                log.debug((Object)("PostgreSQL data directory: " + pgData));
                File postgresConfFile = configFilePath != null ? new File(configFilePath) : new File(pgData, "postgresql.conf");
                log.debug((Object)("PostgreSQL configuration file: " + postgresConfFile));
                if (!postgresConfFile.exists()) {
                    log.warn((Object)("PostgreSQL configuration file (" + postgresConfFile + ") does not exist."));
                } else {
                    try {
                        confFile = new PostgresqlConfFile(postgresConfFile);
                    }
                    catch (IOException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Could not load PostgreSQL configuration file [" + postgresConfFile + "]."), (Throwable)e);
                        }
                        log.warn((Object)("Could not load PostgreSQL configuration file [" + postgresConfFile + "]: " + e));
                    }
                }
            }
            Configuration pluginConfig = context.getDefaultPluginConfiguration();
            pluginConfig.put((Property)new PropertySimple(PGDATA_DIR_CONFIGURATION_PROPERTY, (Object)pgData));
            pluginConfig.put((Property)new PropertySimple(CONFIG_FILE_CONFIGURATION_PROPERTY, (Object)configFilePath));
            if (confFile != null) {
                List<String> listenAddresses;
                String port = confFile.getPort();
                if (port != null) {
                    pluginConfig.put((Property)new PropertySimple(PORT_CONFIGURATION_PROPERTY, (Object)port));
                }
                if ((listenAddresses = confFile.getPropertyList("listen_addresses")).size() > 0) {
                    String listenAddress = listenAddresses.get(0).trim();
                    if ("*".equals(listenAddress)) {
                        listenAddress = "127.0.0.1";
                    }
                    pluginConfig.put((Property)new PropertySimple(HOST_CONFIGURATION_PROPERTY, (Object)listenAddress));
                }
            }
            DiscoveredResourceDetails resourceDetails = PostgresDiscoveryComponent.createResourceDetails(context, pluginConfig, procInfo, false);
            servers.add(resourceDetails);
        }
        return servers;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException {
        ProcessInfo processInfo = null;
        DiscoveredResourceDetails resourceDetails = PostgresDiscoveryComponent.createResourceDetails(discoveryContext, pluginConfig, processInfo, true);
        return resourceDetails;
    }

    protected static DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext discoveryContext, Configuration pluginConfiguration, @Nullable ProcessInfo processInfo, boolean logConnectionFailure) {
        String key = PostgresDiscoveryComponent.buildUrl(pluginConfiguration);
        Connection conn = PostgresDiscoveryComponent.buildConnection(pluginConfiguration, logConnectionFailure);
        String name = PostgresDiscoveryComponent.getServerResourceName(pluginConfiguration, conn);
        String version = PostgresDiscoveryComponent.getVersion(processInfo, discoveryContext.getSystemInformation(), conn);
        JDBCUtil.safeClose((Connection)conn);
        return new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, DEFAULT_RESOURCE_DESCRIPTION, pluginConfiguration, processInfo);
    }

    protected static String buildUrl(Configuration config) {
        String host = config.getSimple(HOST_CONFIGURATION_PROPERTY).getStringValue();
        String port = config.getSimple(PORT_CONFIGURATION_PROPERTY).getStringValue();
        String db = config.getSimple(DB_CONFIGURATION_PROPERTY).getStringValue();
        String url = "jdbc:postgresql://" + host + ":" + port + "/" + db;
        return url;
    }

    protected static String getVersion(ProcessInfo processInfo, SystemInfo systemInfo, Connection conn) {
        String version = null;
        try {
            if (conn != null) {
                version = conn.getMetaData().getDatabaseProductVersion();
            }
        }
        catch (SQLException e) {
            log.info((Object)"Exception detecting postgres instance version.", (Throwable)e);
        }
        if (version == null && processInfo != null) {
            try {
                ProcExe executable = processInfo.getExecutable();
                if (executable != null) {
                    String postgresExe = executable.getName();
                    ProcessExecution execution = new ProcessExecution(postgresExe);
                    execution.setArguments(new String[]{"--version"});
                    execution.setCaptureOutput(true);
                    ProcessExecutionResults results = systemInfo.executeProcess(execution);
                    String versionInfo = results.getCapturedOutput();
                    Matcher m = VERSION_FROM_COMMANDLINE.matcher(versionInfo);
                    if (m.find()) {
                        version = versionInfo.substring(m.start(), m.end());
                    } else {
                        log.debug((Object)"Can't get the process executable - does the agent have the right permissions?");
                    }
                }
            }
            catch (Exception e) {
                log.info((Object)"Failed to obtain Postgres version information from the executable file.", (Throwable)e);
            }
        }
        return version;
    }

    public static Connection buildConnection(Configuration configuration, boolean logFailure) {
        String driverClass = configuration.getSimple(DRIVER_CONFIGURATION_PROPERTY).getStringValue();
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidPluginConfigurationException("Specified JDBC driver class (" + driverClass + ") not found.");
        }
        String url = PostgresDiscoveryComponent.buildUrl(configuration);
        String principal = configuration.getSimple(PRINCIPAL_CONFIGURATION_PROPERTY).getStringValue();
        String credentials = configuration.getSimple(CREDENTIALS_CONFIGURATION_PROPERTY).getStringValue();
        try {
            return DriverManager.getConnection(url, principal, credentials);
        }
        catch (SQLException e) {
            if (logFailure) {
                log.info((Object)("Failed to connect to the database: " + e.getMessage()));
            } else {
                log.debug((Object)("Failed to connect to the database: " + e.getMessage()));
            }
            return null;
        }
    }

    @Nullable
    protected static String getDataDirPath(@NotNull ProcessInfo procInfo) {
        String dataDirPath = null;
        String[] cmdLine = procInfo.getCommandLine();
        for (int i = 0; i < cmdLine.length; ++i) {
            if (!cmdLine[i].equals("-D")) continue;
            if (i != cmdLine.length - 1) {
                dataDirPath = cmdLine[i + 1];
                break;
            }
            log.error((Object)("-D option was last option on postgres command line: " + Arrays.asList(cmdLine)));
        }
        if (dataDirPath == null) {
            dataDirPath = procInfo.getEnvironmentVariable(PGDATA_ENV_VAR);
        }
        if (dataDirPath == null) {
            // empty if block
        }
        return dataDirPath;
    }

    @Nullable
    private static String getConfigFilePath(@NotNull ProcessInfo procInfo) {
        String configFilePath = null;
        String[] cmdLine = procInfo.getCommandLine();
        for (int i = 0; i < cmdLine.length; ++i) {
            if (!cmdLine[i].equals("-c")) continue;
            if (i != cmdLine.length - 1) {
                String paramString = cmdLine[i + 1];
                int equalsIndex = paramString.indexOf(61);
                if (equalsIndex == -1) {
                    log.error((Object)("Invalid value '" + paramString + "' for -c option on postgres command line: " + Arrays.asList(cmdLine)));
                    continue;
                }
                String paramName = paramString.substring(0, equalsIndex);
                if (!paramName.equalsIgnoreCase("config_file")) continue;
                configFilePath = paramString.substring(equalsIndex + 1);
                break;
            }
            log.error((Object)("-c option was last option on postgres command line: " + Arrays.asList(cmdLine)));
        }
        return configFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getDatabaseNames(Connection conn) {
        ArrayList<String> arrayList;
        Statement statement = null;
        ResultSet resultSet = null;
        if (conn == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<String> ret = new ArrayList<String>();
            statement = conn.createStatement();
            resultSet = statement.executeQuery("SELECT *, pg_database_size(datname) FROM pg_database where datistemplate = false");
            while (resultSet.next()) {
                String databaseName = resultSet.getString("datname");
                ret.add(databaseName);
            }
            arrayList = ret;
        }
        catch (SQLException e) {
            List<String> list;
            try {
                log.info((Object)"Failed to obtain the list of databases in a postgres instance", (Throwable)e);
                list = Collections.emptyList();
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(statement, resultSet);
                throw throwable;
            }
            JDBCUtil.safeClose((Statement)statement, (ResultSet)resultSet);
            return list;
        }
        JDBCUtil.safeClose((Statement)statement, (ResultSet)resultSet);
        return arrayList;
    }

    private static String getServerResourceName(Configuration config, Connection conn) {
        List<String> schemas = PostgresDiscoveryComponent.getDatabaseNames(conn);
        if (schemas.size() > 0 && schemas.size() < 3) {
            String firstDatabase = schemas.get(0);
            String secondDatabase = schemas.get(1);
            return POSTGRES_DEFAULT_DATABASE_NAME.equals(firstDatabase) ? secondDatabase : firstDatabase;
        }
        return config.getSimpleValue(DB_CONFIGURATION_PROPERTY, POSTGRES_DEFAULT_DATABASE_NAME);
    }
}

