/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.database.ConnectionPoolingSupport;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.database.PooledConnectionProvider;
import org.rhq.plugins.postgres.PostgresServerComponent;

public class PostgresUserComponent
implements DatabaseComponent<PostgresServerComponent<?>>,
ConnectionPoolingSupport,
MeasurementFacet,
ConfigurationFacet,
DeleteResourceFacet {
    static final String FIND_ROLE_BY_OID = "select * from pg_roles where oid = ?";
    static final String COUNT_ROLES_WITH_OID = "select count(*) from pg_roles where oid = ?";
    static final String FIND_STAT_ACTIVITY_BY_OID_PRE_PG_9_2 = "select (select count(*) from pg_stat_activity where usesysid = ? and current_query != '<IDLE>') as active, (select count(*) from pg_stat_activity where usesysid = ?) as total";
    static final String FIND_STAT_ACTIVITY_BY_OID = "select (select count(*) from pg_stat_activity where usesysid = ? and state = 'active') as active, (select count(*) from pg_stat_activity where usesysid = ?) as total";
    static final String UPDATE_PG_AUTHID_SET_ROLCATUPDATE_WHERE_OID = "update pg_authid set rolcatupdate=? where oid=?";
    private ResourceContext<PostgresServerComponent<?>> resourceContext;
    private long pgRoleOid;

    public void start(ResourceContext<PostgresServerComponent<?>> resourceContext) {
        this.resourceContext = resourceContext;
        try {
            this.pgRoleOid = Long.parseLong(resourceContext.getResourceKey().substring("oid: ".length()));
        }
        catch (Exception e) {
            throw new InvalidPluginConfigurationException("Invalid resource key [" + resourceContext.getResourceKey() + "]");
        }
    }

    public void stop() {
        this.resourceContext = null;
    }

    public boolean supportsConnectionPooling() {
        return true;
    }

    public PooledConnectionProvider getPooledConnectionProvider() {
        return ((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).getPooledConnectionProvider();
    }

    @Deprecated
    public String getUserName() {
        try {
            String result = this.getUserNameInternal();
            if (result == null) {
                throw new RuntimeException("Found no user with oid [" + this.pgRoleOid + "]");
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserNameInternal() throws SQLException {
        ResultSet resultSet;
        PreparedStatement statement;
        Connection connection;
        block3: {
            String string;
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = this.getPooledConnectionProvider().getPooledConnection();
                statement = connection.prepareStatement(FIND_ROLE_BY_OID);
                statement.setLong(1, this.pgRoleOid);
                resultSet = statement.executeQuery();
                if (!resultSet.next()) break block3;
                string = resultSet.getString("rolname");
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)connection, statement, resultSet);
                throw throwable;
            }
            DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
            return string;
        }
        String string = null;
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return string;
    }

    public AvailabilityType getAvailability() {
        if (DatabasePluginUtil.getSingleNumericQueryValue((ResourceComponent)this, (String)COUNT_ROLES_WITH_OID, (Object[])new Object[]{this.pgRoleOid}) == 1.0) {
            return AvailabilityType.UP;
        }
        return AvailabilityType.DOWN;
    }

    public Connection getConnection() {
        return ((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).getConnection();
    }

    public void removeConnection() {
        ((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).removeConnection();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Map values = ((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).isVersionGreaterThan92() ? DatabasePluginUtil.getNumericQueryValues((ResourceComponent)this, (String)FIND_STAT_ACTIVITY_BY_OID, (Object[])new Object[]{this.pgRoleOid, this.pgRoleOid}) : DatabasePluginUtil.getNumericQueryValues((ResourceComponent)this, (String)FIND_STAT_ACTIVITY_BY_OID_PRE_PG_9_2, (Object[])new Object[]{this.pgRoleOid, this.pgRoleOid});
        for (MeasurementScheduleRequest request : metrics) {
            report.addData(new MeasurementDataNumeric(request, (Double)values.get(request.getName())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration loadResourceConfiguration() throws Exception {
        Configuration configuration;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getPooledConnectionProvider().getPooledConnection();
            statement = connection.prepareStatement(FIND_ROLE_BY_OID);
            statement.setLong(1, this.pgRoleOid);
            resultSet = statement.executeQuery();
            resultSet.next();
            Configuration config = new Configuration();
            config.put((Property)new PropertySimple("user", (Object)resultSet.getString("rolname")));
            config.put((Property)new PropertySimple("canLogin", (Object)resultSet.getBoolean("rolcanlogin")));
            config.put((Property)new PropertySimple("inheritRights", (Object)resultSet.getBoolean("rolinherit")));
            boolean rolsuper = resultSet.getBoolean("rolsuper");
            config.put((Property)new PropertySimple("superuser", (Object)rolsuper));
            if (rolsuper) {
                config.put((Property)new PropertySimple("canCreateDatabaseObjects", (Object)String.valueOf(true)));
                config.put((Property)new PropertySimple("canCreateRoles", (Object)String.valueOf(true)));
            } else {
                config.put((Property)new PropertySimple("canCreateDatabaseObjects", (Object)resultSet.getBoolean("rolcreatedb")));
                config.put((Property)new PropertySimple("canCreateRoles", (Object)resultSet.getBoolean("rolcreaterole")));
            }
            config.put((Property)new PropertySimple("canModifyCatalogDirectly", (Object)resultSet.getBoolean("rolcatupdate")));
            config.put((Property)new PropertySimple("connectionLimit", (Object)resultSet.getInt("rolconnlimit")));
            configuration = config;
        }
        catch (Throwable throwable) {
            DatabasePluginUtil.safeClose((Connection)connection, statement, resultSet);
            throw throwable;
        }
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Statement statement;
        Connection connection;
        String currentUserName;
        Configuration config = report.getConfiguration();
        String userName = config.getSimpleValue("user");
        if (userName == null || userName.trim().isEmpty()) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage("User name is missing");
            return;
        }
        try {
            currentUserName = this.getUserNameInternal();
        }
        catch (SQLException e) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessageFromThrowable((Throwable)e);
            return;
        }
        if (!userName.equals(currentUserName)) {
            connection = null;
            statement = null;
            try {
                connection = this.getPooledConnectionProvider().getPooledConnection();
                statement = connection.createStatement();
                statement.executeUpdate("alter role " + currentUserName + " rename to " + userName);
            }
            catch (SQLException e) {
                try {
                    report.setStatus(ConfigurationUpdateStatus.FAILURE);
                    report.setErrorMessageFromThrowable((Throwable)e);
                }
                catch (Throwable throwable) {
                    DatabasePluginUtil.safeClose((Connection)connection, statement);
                    throw throwable;
                }
                DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement);
                return;
            }
            DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement);
        }
        connection = null;
        statement = null;
        try {
            connection = this.getPooledConnectionProvider().getPooledConnection();
            statement = connection.prepareStatement(PostgresUserComponent.buildUserSql(config, false));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                report.setStatus(ConfigurationUpdateStatus.FAILURE);
                report.setErrorMessageFromThrowable((Throwable)e);
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)connection, statement);
                throw throwable;
            }
            DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement);
            return;
        }
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement);
        try {
            connection = this.getPooledConnectionProvider().getPooledConnection();
            statement = connection.prepareStatement(UPDATE_PG_AUTHID_SET_ROLCATUPDATE_WHERE_OID);
            statement.setBoolean(1, Boolean.valueOf(config.getSimpleValue("superuser")) != false && Boolean.valueOf(config.getSimpleValue("canModifyCatalogDirectly")) != false);
            statement.setLong(2, this.pgRoleOid);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessageFromThrowable((Throwable)e);
            return;
        }
        finally {
            DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement);
        }
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
    }

    static String buildUserSql(Configuration config, boolean newUser) {
        StringBuilder sql = new StringBuilder();
        if (newUser) {
            sql.append("create");
        } else {
            sql.append("alter");
        }
        sql.append(" user ").append(config.getSimpleValue("user"));
        sql.append(Boolean.valueOf(config.getSimpleValue("canLogin")) != false ? " LOGIN" : " NOLOGIN");
        String password = config.getSimpleValue("password");
        if (password != null && !password.trim().isEmpty()) {
            sql.append(" password '").append(password).append("'");
        }
        sql.append(Boolean.valueOf(config.getSimpleValue("inheritRights")) != false ? " INHERIT" : " NOINHERIT");
        if (Boolean.valueOf(config.getSimpleValue("superuser")).booleanValue()) {
            sql.append(" SUPERUSER");
        } else {
            sql.append(" NOSUPERUSER");
            sql.append(Boolean.valueOf(config.getSimpleValue("canCreateDatabaseObjects")) != false ? " CREATEDB" : " NOCREATEDB");
            sql.append(Boolean.valueOf(config.getSimpleValue("canCreateRoles")) != false ? " CREATEROLE" : " NOCREATEROLE");
        }
        sql.append(" connection limit ");
        PropertySimple connectionLimit = config.getSimple("connectionLimit");
        if (connectionLimit != null) {
            sql.append(connectionLimit.getIntegerValue());
        } else {
            sql.append("-1");
        }
        return sql.toString();
    }

    public static String getUserSQL(Configuration config, UpdateType type) {
        String result;
        switch (type) {
            case CREATE: {
                result = PostgresUserComponent.buildUserSql(config, true);
                break;
            }
            case ALTER: {
                result = PostgresUserComponent.buildUserSql(config, false);
                break;
            }
            case DROP: {
                result = "drop user " + config.getSimpleValue("user");
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource() throws Exception {
        String userName = this.getUserNameInternal();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getPooledConnectionProvider().getPooledConnection();
            statement = connection.createStatement();
            statement.executeUpdate("drop role " + userName);
        }
        catch (Throwable throwable) {
            DatabasePluginUtil.safeClose((Connection)connection, statement);
            throw throwable;
        }
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement);
    }

    static class ResourceConfig {
        static final String USER = "user";
        static final String CAN_LOGIN = "canLogin";
        static final String PASSWORD = "password";
        static final String INHERIT_RIGHTS = "inheritRights";
        static final String SUPERUSER = "superuser";
        static final String CAN_CREATE_DATABASE_OBJECTS = "canCreateDatabaseObjects";
        static final String CAN_CREATE_ROLES = "canCreateRoles";
        static final String CAN_UPDATE_SYSTEM_CATALOGS_DIRECTLY = "canModifyCatalogDirectly";
        static final String CONNECTION_LIMIT = "connectionLimit";

        private ResourceConfig() {
        }
    }

    @Deprecated
    public static enum UpdateType {
        CREATE,
        ALTER,
        DROP;

    }
}

